/*
 * Decompiled with CFR 0.152.
 */
package purejavahidapi.linux;

import java.io.IOException;
import java.io.StringReader;
import java.util.Properties;
import purejavahidapi.linux.UdevLibrary;

class HidDeviceInfo
extends purejavahidapi.HidDeviceInfo {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HidDeviceInfo(String sysfs_path) throws IOException {
        this.m_Path = sysfs_path;
        UdevLibrary.udev_device raw_dev = null;
        UdevLibrary.udev udev2 = null;
        UdevLibrary.udev_device hid_dev = null;
        UdevLibrary.udev_device usb_dev = null;
        try {
            udev2 = UdevLibrary.udev_new();
            raw_dev = UdevLibrary.udev_device_new_from_syspath(udev2, sysfs_path);
            String dev_path = UdevLibrary.udev_device_get_devnode(raw_dev);
            hid_dev = UdevLibrary.udev_device_get_parent_with_subsystem_devtype(raw_dev, "hid", null);
            if (hid_dev == null) {
                throw new IOException("hid_dev == null");
            }
            if (dev_path == null) {
                throw new IOException("dev_path == null");
            }
            usb_dev = UdevLibrary.udev_device_get_parent_with_subsystem_devtype(raw_dev, "usb", "usb_device");
            String usb_dev_path = UdevLibrary.udev_device_get_devnode(usb_dev);
            Properties p = new Properties();
            p.load(new StringReader(UdevLibrary.udev_device_get_sysattr_value(hid_dev, "uevent")));
            String[] hidId = ((String)p.get("HID_ID")).split(":");
            short bus = (short)Long.parseLong(hidId[0], 16);
            this.m_DeviceId = usb_dev_path;
            this.m_VendorId = (short)Long.parseLong(hidId[1], 16);
            this.m_ProductId = (short)Long.parseLong(hidId[2], 16);
            this.m_ProductString = (String)p.get("HID_NAME");
            this.m_SerialNumberString = (String)p.get("HID_UNIQ");
            if (bus != 3 && bus != 5) {
                throw new IOException("bus != BUS_USB && bus != BUS_BLUETOOTH ");
            }
            switch (bus) {
                case 3: {
                    if (usb_dev == null) {
                        throw new IOException("usb_dev == null");
                    }
                    UdevLibrary.udev_device intf_dev = UdevLibrary.udev_device_get_parent_with_subsystem_devtype(raw_dev, "usb", "usb_interface");
                    if (intf_dev == null) return;
                    String string = UdevLibrary.udev_device_get_sysattr_value(intf_dev, "bInterfaceNumber");
                    return;
                }
                case 5: {
                    return;
                }
            }
            return;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            if (raw_dev != null) {
                UdevLibrary.udev_device_unref(raw_dev);
            }
            if (udev2 != null) {
                UdevLibrary.udev_unref(udev2);
            }
        }
    }
}

