/*
 * Decompiled with CFR 0.152.
 */
package purejavahidapi.macosx;

import com.sun.jna.Callback;
import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import com.sun.jna.Structure;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import purejavahidapi.macosx.CoreFoundationLibrary;

public class IOHIDManagerLibrary {
    private static IOHIDManagerLib INSTANCE = (IOHIDManagerLib)Native.load((String)"IOKit", IOHIDManagerLib.class);
    public static final int kIOHIDOptionsTypeNone = 0;
    public static final int kIOHIDOptionsTypeSeizeDevice = 1;
    public static final String kIOHIDTransportKey = "Transport";
    public static final String kIOHIDVendorIDKey = "VendorID";
    public static final String kIOHIDVendorIDSourceKey = "VendorIDSource";
    public static final String kIOHIDProductIDKey = "ProductID";
    public static final String kIOHIDVersionNumberKey = "VersionNumber";
    public static final String kIOHIDManufacturerKey = "Manufacturer";
    public static final String kIOHIDProductKey = "Product";
    public static final String kIOHIDSerialNumberKey = "SerialNumber";
    public static final String kIOHIDCountryCodeKey = "CountryCode";
    public static final String kIOHIDStandardTypeKey = "StandardType";
    public static final String kIOHIDDeviceKeyboardStandardTypeKey = "DeviceKeyboardStandardType";
    public static final String kIOHIDLocationIDKey = "LocationID";
    public static final String kIOHIDDeviceUsageKey = "DeviceUsage";
    public static final String kIOHIDDeviceUsagePageKey = "DeviceUsagePage";
    public static final String kIOHIDDeviceUsagePairsKey = "DeviceUsagePairs";
    public static final String kIOHIDPrimaryUsageKey = "PrimaryUsage";
    public static final String kIOHIDPrimaryUsagePageKey = "PrimaryUsagePage";
    public static final String kIOHIDMaxInputReportSizeKey = "MaxInputReportSize";
    public static final String kIOHIDMaxOutputReportSizeKey = "MaxOutputReportSize";
    public static final String kIOHIDMaxFeatureReportSizeKey = "MaxFeatureReportSize";
    public static final String kIOHIDReportIntervalKey = "ReportInterval";
    public static final String kIOHIDReportDescriptorKey = "ReportDescriptor";
    public static final String kIOHIDResetKey = "Reset";
    public static final String kIOHIDDeviceKeyboardLanguageKey = "DeviceKeyboardLanguage";
    public static final String kIOHIDDeviceKey = "IOHIDDevice";
    public static final int kIOReturnSuccess = 0;
    public static final int kIOHIDReportTypeInput = 0;
    public static final int kIOHIDReportTypeOutput = 1;
    public static final int kIOHIDReportTypeFeature = 2;
    public static final int kIOHIDReportTypeCount = 3;
    public static final int kIOHIDElementTypeInput_Misc = 1;
    public static final int kIOHIDElementTypeInput_Button = 2;
    public static final int kIOHIDElementTypeInput_Axis = 3;
    public static final int kIOHIDElementTypeInput_ScanCodes = 4;
    public static final int kIOHIDElementTypeOutput = 129;
    public static final int kIOHIDElementTypeFeature = 257;
    public static final int kIOHIDElementTypeCollection = 513;
    public static final int kIOHIDElementCollectionTypePhysical = 0;
    public static final int kIOHIDElementCollectionTypeApplication = 1;
    public static final int kIOHIDElementCollectionTypeLogical = 2;
    public static final int kIOHIDElementCollectionTypeReport = 3;
    public static final int kIOHIDElementCollectionTypeNamedArray = 4;
    public static final int kIOHIDElementCollectionTypeUsageSwitch = 5;
    public static final int kIOHIDElementCollectionTypeUsageModifier = 6;

    public static IOHIDManagerRef IOHIDManagerCreate(CoreFoundationLibrary.CFAllocatorRef allocator, int options) {
        return INSTANCE.IOHIDManagerCreate(allocator, options);
    }

    public static void IOHIDManagerSetDeviceMatching(IOHIDManagerRef manager, CFDictionaryRef matching) {
        INSTANCE.IOHIDManagerSetDeviceMatching(manager, matching);
    }

    public static void IOHIDManagerScheduleWithRunLoop(IOHIDManagerRef manager, CoreFoundationLibrary.CFRunLoopRef runLoop, CoreFoundationLibrary.CFStringRef runLoopMode) {
        INSTANCE.IOHIDManagerScheduleWithRunLoop(manager, runLoop, runLoopMode);
    }

    public static CoreFoundationLibrary.CFSetRef IOHIDManagerCopyDevices(IOHIDManagerRef manager) {
        return INSTANCE.IOHIDManagerCopyDevices(manager);
    }

    public static CoreFoundationLibrary.CFTypeRef IOHIDDeviceGetProperty(IOHIDDeviceRef device, CoreFoundationLibrary.CFStringRef key) {
        return INSTANCE.IOHIDDeviceGetProperty(device, key);
    }

    public static int IOHIDDeviceOpen(IOHIDDeviceRef device, int options) {
        return INSTANCE.IOHIDDeviceOpen(device, options);
    }

    public static void IOHIDDeviceRegisterInputReportCallback(IOHIDDeviceRef device, Pointer report, int reportLength, IOHIDReportCallback callback, Pointer context) {
        INSTANCE.IOHIDDeviceRegisterInputReportCallback(device, report, new NativeLong((long)reportLength), callback, context);
    }

    public static void IOHIDManagerRegisterDeviceRemovalCallback(IOHIDManagerRef manager, IOHIDDeviceCallback callback, Pointer context) {
        INSTANCE.IOHIDManagerRegisterDeviceRemovalCallback(manager, callback, context);
    }

    public static void IOHIDDeviceScheduleWithRunLoop(IOHIDDeviceRef device, CoreFoundationLibrary.CFRunLoopRef runLoop, CoreFoundationLibrary.CFStringRef runLoopMode) {
        INSTANCE.IOHIDDeviceScheduleWithRunLoop(device, runLoop, runLoopMode);
    }

    public static void IOHIDDeviceUnscheduleFromRunLoop(IOHIDDeviceRef device, CoreFoundationLibrary.CFRunLoopRef runLoop, CoreFoundationLibrary.CFStringRef runLoopMode) {
        INSTANCE.IOHIDDeviceUnscheduleFromRunLoop(device, runLoop, runLoopMode);
    }

    public static int IOHIDDeviceClose(IOHIDDeviceRef device, int options) {
        return INSTANCE.IOHIDDeviceClose(device, options);
    }

    public static int IOHIDDeviceGetReport(IOHIDDeviceRef device, int reportType, int reportID, ByteBuffer report, int[] pReportLength) {
        NativeLong[] t = new NativeLong[]{new NativeLong((long)pReportLength[0])};
        int res = INSTANCE.IOHIDDeviceGetReport(device, reportType, new NativeLong((long)reportID), report, t);
        pReportLength[0] = t[0].intValue();
        return res;
    }

    public static int IOHIDDeviceSetReport(IOHIDDeviceRef device, int reportType, int reportID, ByteBuffer report, int pReportLength) {
        return INSTANCE.IOHIDDeviceSetReport(device, reportType, new NativeLong((long)reportID), report, new NativeLong((long)pReportLength));
    }

    public static int IOHIDManagerClose(IOHIDManagerRef manager, int options) {
        return INSTANCE.IOHIDManagerClose(manager, options);
    }

    public static CoreFoundationLibrary.CFArrayRef IOHIDDeviceCopyMatchingElements(IOHIDDeviceRef inIOHIDDeviceRef, CFDictionaryRef inMatchingCFDictRef, int inOptions) {
        return INSTANCE.IOHIDDeviceCopyMatchingElements(inIOHIDDeviceRef, inMatchingCFDictRef, inOptions);
    }

    public static int IOHIDElementGetType(IOHIDElementRef element) {
        return INSTANCE.IOHIDElementGetType(element);
    }

    public static int IOHIDElementGetUsagePage(IOHIDElementRef element) {
        return INSTANCE.IOHIDElementGetUsagePage(element);
    }

    public static int IOHIDElementGetUsage(IOHIDElementRef element) {
        return INSTANCE.IOHIDElementGetUsage(element);
    }

    public static CoreFoundationLibrary.CFStringRef IOHIDElementGetName(IOHIDElementRef element) {
        return INSTANCE.IOHIDElementGetName(element);
    }

    public static int IOHIDElementGetReportID(IOHIDElementRef element) {
        return INSTANCE.IOHIDElementGetReportID(element);
    }

    public static int IOHIDElementGetReportSize(IOHIDElementRef element) {
        return INSTANCE.IOHIDElementGetReportSize(element);
    }

    public static int IOHIDElementGetReportCount(IOHIDElementRef element) {
        return INSTANCE.IOHIDElementGetReportCount(element);
    }

    public static int IOHIDElementGetUnit(IOHIDElementRef element) {
        return INSTANCE.IOHIDElementGetUnit(element);
    }

    public static int IOHIDElementGetUnitExponent(IOHIDElementRef element) {
        return INSTANCE.IOHIDElementGetUnitExponent(element);
    }

    public static int IOHIDElementGetLogicalMin(IOHIDElementRef element) {
        return INSTANCE.IOHIDElementGetLogicalMin(element);
    }

    public static int IOHIDElementGetLogicalMax(IOHIDElementRef element) {
        return INSTANCE.IOHIDElementGetLogicalMax(element);
    }

    public static int IOHIDElementGetPhysicalMin(IOHIDElementRef element) {
        return INSTANCE.IOHIDElementGetPhysicalMin(element);
    }

    public static int IOHIDElementGetPhysicalMax(IOHIDElementRef element) {
        return INSTANCE.IOHIDElementGetPhysicalMax(element);
    }

    public static boolean IOHIDElementIsVirtual(IOHIDElementRef element) {
        return INSTANCE.IOHIDElementIsVirtual(element);
    }

    public static boolean IOHIDElementIsRelative(IOHIDElementRef element) {
        return INSTANCE.IOHIDElementIsRelative(element);
    }

    public static boolean IOHIDElementIsWrapping(IOHIDElementRef element) {
        return INSTANCE.IOHIDElementIsWrapping(element);
    }

    public static boolean IOHIDElementIsArray(IOHIDElementRef element) {
        return INSTANCE.IOHIDElementIsArray(element);
    }

    public static boolean IOHIDElementIsNonLinear(IOHIDElementRef element) {
        return INSTANCE.IOHIDElementIsNonLinear(element);
    }

    public static boolean IOHIDElementHasPreferredState(IOHIDElementRef element) {
        return INSTANCE.IOHIDElementHasPreferredState(element);
    }

    public static boolean IOHIDElementHasNullState(IOHIDElementRef element) {
        return INSTANCE.IOHIDElementHasNullState(element);
    }

    public static IOHIDDeviceRef IOHIDElementGetDevice(IOHIDElementRef element) {
        return INSTANCE.IOHIDElementGetDevice(element);
    }

    public static IOHIDElementRef IOHIDElementGetParent(IOHIDElementRef element) {
        return INSTANCE.IOHIDElementGetParent(element);
    }

    public static CoreFoundationLibrary.CFArrayRef IOHIDElementGetChildren(IOHIDElementRef element) {
        return INSTANCE.IOHIDElementGetChildren(element);
    }

    public static int IOHIDElementGetCookie(IOHIDElementRef element) {
        return INSTANCE.IOHIDElementGetCookie(element);
    }

    public static int IOHIDElementGetCollectionType(IOHIDElementRef element) {
        return INSTANCE.IOHIDElementGetCollectionType(element);
    }

    public static CoreFoundationLibrary.CFTypeRef IOHIDElementGetProperty(IOHIDElementRef element, CoreFoundationLibrary.CFStringRef key) {
        return INSTANCE.IOHIDElementGetProperty(element, key);
    }

    public static CoreFoundationLibrary.CFMutableDictionaryRef IOServiceMatching(String name) {
        return INSTANCE.IOServiceMatching(name);
    }

    public static int IOServiceGetMatchingService(mach_port_t masterPort, CoreFoundationLibrary.CFMutableDictionaryRef matching, io_iterator_t[] iterator) {
        return INSTANCE.IOServiceGetMatchingService(masterPort, matching, iterator);
    }

    public static int IOServiceGetMatchingServices(mach_port_t masterPort, CoreFoundationLibrary.CFMutableDictionaryRef matching, io_iterator_t[] iterator) {
        return INSTANCE.IOServiceGetMatchingServices(masterPort, matching, iterator);
    }

    public static io_object_t IOIteratorNext(io_iterator_t iterator) {
        return INSTANCE.IOIteratorNext(iterator);
    }

    public static int IOCreatePlugInInterfaceForService(io_object_t ioDeviceObj, CoreFoundationLibrary.CFUUIDRef kIOUSBDeviceUserClientTypeID2, CoreFoundationLibrary.CFUUIDRef kIOCFPlugInInterfaceID2, Memory ioPlugin, int[] score) {
        return INSTANCE.IOCreatePlugInInterfaceForService(ioDeviceObj, kIOUSBDeviceUserClientTypeID2, kIOCFPlugInInterfaceID2, ioPlugin, score);
    }

    public static int IOMasterPort(Pointer p, mach_port_t[] t) {
        return INSTANCE.IOMasterPort(p, t);
    }

    public static interface IOHIDManagerLib
    extends Library {
        public IOHIDManagerRef IOHIDManagerCreate(CoreFoundationLibrary.CFAllocatorRef var1, int var2);

        public void IOHIDManagerSetDeviceMatching(IOHIDManagerRef var1, CFDictionaryRef var2);

        public void IOHIDManagerScheduleWithRunLoop(IOHIDManagerRef var1, CoreFoundationLibrary.CFRunLoopRef var2, CoreFoundationLibrary.CFStringRef var3);

        public CoreFoundationLibrary.CFSetRef IOHIDManagerCopyDevices(IOHIDManagerRef var1);

        public CoreFoundationLibrary.CFTypeRef IOHIDDeviceGetProperty(IOHIDDeviceRef var1, CoreFoundationLibrary.CFStringRef var2);

        public int IOHIDDeviceOpen(IOHIDDeviceRef var1, int var2);

        public void IOHIDDeviceRegisterInputReportCallback(IOHIDDeviceRef var1, Pointer var2, NativeLong var3, IOHIDReportCallback var4, Pointer var5);

        public void IOHIDManagerRegisterDeviceRemovalCallback(IOHIDManagerRef var1, IOHIDDeviceCallback var2, Pointer var3);

        public void IOHIDDeviceScheduleWithRunLoop(IOHIDDeviceRef var1, CoreFoundationLibrary.CFRunLoopRef var2, CoreFoundationLibrary.CFStringRef var3);

        public void IOHIDDeviceUnscheduleFromRunLoop(IOHIDDeviceRef var1, CoreFoundationLibrary.CFRunLoopRef var2, CoreFoundationLibrary.CFStringRef var3);

        public CoreFoundationLibrary.CFRunLoopRef CFRunLoopGetMain();

        public int IOHIDDeviceClose(IOHIDDeviceRef var1, int var2);

        public int IOHIDDeviceGetReport(IOHIDDeviceRef var1, int var2, NativeLong var3, ByteBuffer var4, NativeLong[] var5);

        public int IOHIDDeviceSetReport(IOHIDDeviceRef var1, int var2, NativeLong var3, ByteBuffer var4, NativeLong var5);

        public int IOHIDManagerClose(IOHIDManagerRef var1, int var2);

        public CoreFoundationLibrary.CFArrayRef IOHIDDeviceCopyMatchingElements(IOHIDDeviceRef var1, CFDictionaryRef var2, int var3);

        public int IOHIDElementGetType(IOHIDElementRef var1);

        public int IOHIDElementGetUsagePage(IOHIDElementRef var1);

        public int IOHIDElementGetUsage(IOHIDElementRef var1);

        public CoreFoundationLibrary.CFStringRef IOHIDElementGetName(IOHIDElementRef var1);

        public int IOHIDElementGetReportID(IOHIDElementRef var1);

        public int IOHIDElementGetReportSize(IOHIDElementRef var1);

        public int IOHIDElementGetReportCount(IOHIDElementRef var1);

        public int IOHIDElementGetUnit(IOHIDElementRef var1);

        public int IOHIDElementGetUnitExponent(IOHIDElementRef var1);

        public int IOHIDElementGetLogicalMin(IOHIDElementRef var1);

        public int IOHIDElementGetLogicalMax(IOHIDElementRef var1);

        public int IOHIDElementGetPhysicalMin(IOHIDElementRef var1);

        public int IOHIDElementGetPhysicalMax(IOHIDElementRef var1);

        public boolean IOHIDElementIsVirtual(IOHIDElementRef var1);

        public boolean IOHIDElementIsRelative(IOHIDElementRef var1);

        public boolean IOHIDElementIsWrapping(IOHIDElementRef var1);

        public boolean IOHIDElementIsArray(IOHIDElementRef var1);

        public boolean IOHIDElementIsNonLinear(IOHIDElementRef var1);

        public boolean IOHIDElementHasPreferredState(IOHIDElementRef var1);

        public boolean IOHIDElementHasNullState(IOHIDElementRef var1);

        public IOHIDDeviceRef IOHIDElementGetDevice(IOHIDElementRef var1);

        public IOHIDElementRef IOHIDElementGetParent(IOHIDElementRef var1);

        public CoreFoundationLibrary.CFArrayRef IOHIDElementGetChildren(IOHIDElementRef var1);

        public int IOHIDElementGetCookie(IOHIDElementRef var1);

        public int IOHIDElementGetCollectionType(IOHIDElementRef var1);

        public CoreFoundationLibrary.CFTypeRef IOHIDElementGetProperty(IOHIDElementRef var1, CoreFoundationLibrary.CFStringRef var2);

        public CoreFoundationLibrary.CFMutableDictionaryRef IOServiceMatching(String var1);

        public int IOServiceGetMatchingService(mach_port_t var1, CoreFoundationLibrary.CFMutableDictionaryRef var2, io_iterator_t[] var3);

        public int IOServiceGetMatchingServices(mach_port_t var1, CoreFoundationLibrary.CFMutableDictionaryRef var2, io_iterator_t[] var3);

        public io_object_t IOIteratorNext(io_iterator_t var1);

        public int IOCreatePlugInInterfaceForService(io_object_t var1, CoreFoundationLibrary.CFUUIDRef var2, CoreFoundationLibrary.CFUUIDRef var3, Memory var4, int[] var5);

        public int IOMasterPort(Pointer var1, mach_port_t[] var2);
    }

    public static interface IOHIDDeviceCallback
    extends Callback {
        public void hid_device_removal_callback(Pointer var1, int var2, Pointer var3, IOHIDDeviceRef var4);
    }

    public static interface IOHIDReportCallback
    extends Callback {
        public void callback(Pointer var1, int var2, Pointer var3, int var4, int var5, Pointer var6, NativeLong var7);
    }

    public static class IOUSBDeviceInterface320
    extends Structure {
        public Pointer reserved;
        public Pointer QueryInterface;
        public Pointer AddRef;
        public Pointer Release;
        public DummyCallback CreateDeviceAsyncEventSource;
        public DummyCallback GetDeviceAsyncEventSource;
        public DummyCallback CreateDeviceAsyncPort;
        public DummyCallback GetDeviceAsyncPort;
        public DummyCallback USBDeviceOpen;
        public DummyCallback USBDeviceClose;
        public DummyCallback GetDeviceClass;
        public DummyCallback GetDeviceSubClass;
        public DummyCallback GetDeviceProtocol;
        public DummyCallback GetDeviceVendor;
        public DummyCallback GetDeviceProduct;
        public DummyCallback GetDeviceReleaseNumber;
        public DummyCallback GetDeviceAddress;
        public DummyCallback GetDeviceBusPowerAvailable;
        public DummyCallback GetDeviceSpeed;
        public DummyCallback GetNumberOfConfigurations;
        public DummyCallback GetLocationID;
        public DummyCallback GetConfigurationDescriptorPtr;
        public DummyCallback GetConfiguration;
        public DummyCallback SetConfiguration;
        public DummyCallback GetBusFrameNumber;
        public DummyCallback ResetDevice;
        public DeviceRequestCallback DeviceRequest;
        public DummyCallback DeviceRequestAsync;
        public DummyCallback CreateInterfaceIterator;

        public IOUSBDeviceInterface320(Pointer pointer) {
            super(pointer);
        }

        public IOUSBDeviceInterface320() {
        }

        protected List<String> getFieldOrder() {
            return Arrays.asList("reserved", "QueryInterface", "AddRef", "Release", "CreateDeviceAsyncEventSource", "GetDeviceAsyncEventSource", "CreateDeviceAsyncPort", "GetDeviceAsyncPort", "USBDeviceOpen", "USBDeviceClose", "GetDeviceClass", "GetDeviceSubClass", "GetDeviceProtocol", "GetDeviceVendor", "GetDeviceProduct", "GetDeviceReleaseNumber", "GetDeviceAddress", "GetDeviceBusPowerAvailable", "GetDeviceSpeed", "GetNumberOfConfigurations", "GetLocationID", "GetConfigurationDescriptorPtr", "GetConfiguration", "SetConfiguration", "GetBusFrameNumber", "ResetDevice", "DeviceRequest", "DeviceRequestAsync", "CreateInterfaceIterator");
        }

        public static interface DeviceRequestCallback
        extends Callback {
            public int f(Pointer var1, IOUSBDevRequest var2);
        }

        public static interface ReleaseCallback
        extends Callback {
            public void f(Pointer var1);
        }

        public static interface AddRefCallback
        extends Callback {
            public void f(Pointer var1);
        }

        public static interface QueryInterfaceCallback
        extends Callback {
            public int f(Pointer var1, CoreFoundationLibrary.CFUUID.ByValue var2, Pointer var3);
        }

        public static interface DummyCallback
        extends Callback {
            public void f();
        }
    }

    public static class IOCFPlugInInterface
    extends Structure {
        public Pointer reserved;
        public QueryInterfaceCallback QueryInterface;
        public Pointer AddRef;
        public Pointer Release;
        public short version;
        public short revision;

        public IOCFPlugInInterface(Pointer pointer) {
            super(pointer);
        }

        public IOCFPlugInInterface() {
        }

        protected List<String> getFieldOrder() {
            return Arrays.asList("reserved", "QueryInterface", "AddRef", "Release", "version", "revision");
        }

        public static interface DeviceRequestCallback
        extends Callback {
            public int f(Pointer var1, IOUSBDevRequest var2);
        }

        public static interface ReleaseCallback
        extends Callback {
            public void f(Pointer var1);
        }

        public static interface AddRefCallback
        extends Callback {
            public void f(Pointer var1);
        }

        public static interface QueryInterfaceCallback
        extends Callback {
            public int f(Pointer var1, CoreFoundationLibrary.CFUUID.ByValue var2, Pointer var3);
        }
    }

    public static class IOUSBDevRequest
    extends Structure {
        public byte bmRequestType;
        public byte bRequest;
        public short wValue;
        public short wIndex;
        public short wLength;
        public Pointer pData;
        public int wLenDone;

        protected List<String> getFieldOrder() {
            return Arrays.asList("bmRequestType", "bRequest", "wValue", "wIndex", "wLength", "pData", "wLenDone");
        }
    }

    public static class IOUSBDeviceRef
    extends PointerType {
        public IOUSBDeviceRef(Pointer pointer) {
            super(pointer);
        }

        public IOUSBDeviceRef() {
        }
    }

    public static class IOHIDElementRef
    extends PointerType {
        public IOHIDElementRef(Pointer pointer) {
            super(pointer);
        }

        public IOHIDElementRef() {
        }
    }

    public static class IOHIDDeviceRef
    extends PointerType {
        public IOHIDDeviceRef(Pointer pointer) {
            super(pointer);
        }

        public IOHIDDeviceRef() {
        }
    }

    public static class CFDictionaryRef
    extends PointerType {
        public CFDictionaryRef(Pointer pointer) {
            super(pointer);
        }

        public CFDictionaryRef() {
        }
    }

    public static class mach_port_t
    extends PointerType {
        public mach_port_t(Pointer pointer) {
            super(pointer);
        }

        public mach_port_t() {
        }
    }

    public static class io_iterator_t
    extends PointerType {
        public io_iterator_t(Pointer pointer) {
            super(pointer);
        }

        public io_iterator_t() {
        }
    }

    public static class io_object_t
    extends PointerType {
        public io_object_t(Pointer pointer) {
            super(pointer);
        }

        public io_object_t() {
        }
    }

    public static class io_cf_plugin_ref_t
    extends PointerType {
        public io_cf_plugin_ref_t(Pointer pointer) {
            super(pointer);
        }

        public io_cf_plugin_ref_t() {
        }
    }

    public static class io_service_t
    extends PointerType {
        public io_service_t(Pointer pointer) {
            super(pointer);
        }

        public io_service_t() {
        }
    }

    public static class IOHIDManagerRef
    extends PointerType {
        static final int kIOHIDOptionsTypeNone = 0;

        public IOHIDManagerRef(Pointer pointer) {
            super(pointer);
        }

        public IOHIDManagerRef() {
        }
    }

    public static class IOMemoryDescriptor
    extends PointerType {
        public IOMemoryDescriptor(Pointer pointer) {
            super(pointer);
        }

        public IOMemoryDescriptor() {
        }
    }
}

