/*
 * Decompiled with CFR 0.152.
 */
package purejavahidapi.windows;

import com.sun.jna.Structure;
import com.sun.jna.platform.win32.DBT;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.platform.win32.WinUser;
import com.sun.jna.platform.win32.Wtsapi32;
import purejavahidapi.shared.SyncPoint;
import purejavahidapi.windows.SetupApiLibrary;
import purejavahidapi.windows.WindowsBackend;

public class DeviceRemovalHandler
implements WinUser.WindowProc {
    private WindowsBackend m_WindowsBackend;
    private SyncPoint m_StartupSync;

    public DeviceRemovalHandler(WindowsBackend windowsBackend) {
        this.m_WindowsBackend = windowsBackend;
        this.m_StartupSync = new SyncPoint(2);
        Runnable threadRunnable = new Runnable(){

            @Override
            public void run() {
                WinDef.HWND hWnd;
                String wndClassName = new String("WindowClass");
                WinDef.HMODULE hInst = Kernel32.INSTANCE.GetModuleHandle(null);
                if (hInst == null) {
                    WindowsBackend.reportLastError();
                }
                WinUser.WNDCLASSEX wndClassEx = new WinUser.WNDCLASSEX();
                wndClassEx.hInstance = hInst;
                wndClassEx.lpfnWndProc = DeviceRemovalHandler.this;
                wndClassEx.lpszClassName = wndClassName;
                WinDef.ATOM wndClassRef = User32.INSTANCE.RegisterClassEx(wndClassEx);
                if (wndClassRef == null) {
                    WindowsBackend.reportLastError();
                }
                if ((hWnd = User32.INSTANCE.CreateWindowEx(8, "WindowClass", "", 0, 0, 0, 0, 0, null, null, (WinDef.HINSTANCE)hInst, null)) == null) {
                    WindowsBackend.reportLastError();
                }
                if (!Wtsapi32.INSTANCE.WTSRegisterSessionNotification(hWnd, 0)) {
                    WindowsBackend.reportLastError();
                }
                DBT.DEV_BROADCAST_DEVICEINTERFACE notificationFilter = new DBT.DEV_BROADCAST_DEVICEINTERFACE();
                notificationFilter.dbcc_size = notificationFilter.size();
                notificationFilter.dbcc_devicetype = 5;
                notificationFilter.dbcc_classguid = DBT.GUID_DEVINTERFACE_USB_DEVICE;
                WinUser.HDEVNOTIFY hDevNotify = User32.INSTANCE.RegisterDeviceNotification((WinNT.HANDLE)hWnd, (Structure)notificationFilter, 0);
                if (hDevNotify == null) {
                    WindowsBackend.reportLastError();
                }
                DeviceRemovalHandler.this.m_StartupSync.waitAndSync();
                WinUser.MSG msg = new WinUser.MSG();
                while (User32.INSTANCE.GetMessage(msg, hWnd, 0, 0) != 0) {
                    User32.INSTANCE.TranslateMessage(msg);
                    User32.INSTANCE.DispatchMessage(msg);
                }
                if (!User32.INSTANCE.UnregisterDeviceNotification(hDevNotify)) {
                    WindowsBackend.reportLastError();
                }
                if (!Wtsapi32.INSTANCE.WTSUnRegisterSessionNotification(hWnd)) {
                    WindowsBackend.reportLastError();
                }
                if (!User32.INSTANCE.UnregisterClass(wndClassRef.toString(), (WinDef.HINSTANCE)hInst)) {
                    WindowsBackend.reportLastError();
                }
                if (!User32.INSTANCE.DestroyWindow(hWnd)) {
                    WindowsBackend.reportLastError();
                }
            }
        };
        Thread thread = new Thread(threadRunnable, this.getClass().getSimpleName());
        thread.setDaemon(true);
        thread.start();
        this.m_StartupSync.waitAndSync();
    }

    public WinDef.LRESULT callback(WinDef.HWND hwnd, int uMsg, WinDef.WPARAM wParam, WinDef.LPARAM lParam) {
        switch (uMsg) {
            case 2: {
                User32.INSTANCE.PostQuitMessage(0);
                return new WinDef.LRESULT(0L);
            }
            case 537: {
                WinDef.LRESULT lResult = this.onDeviceChange(wParam, lParam);
                return lResult != null ? lResult : User32.INSTANCE.DefWindowProc(hwnd, uMsg, wParam, lParam);
            }
        }
        return User32.INSTANCE.DefWindowProc(hwnd, uMsg, wParam, lParam);
    }

    protected WinDef.LRESULT onDeviceChange(WinDef.WPARAM wParam, WinDef.LPARAM lParam) {
        switch (wParam.intValue()) {
            case 32772: {
                return this.onDeviceChangeRemoveComplete(lParam);
            }
        }
        return null;
    }

    private void handleDeviceRemoval(String name) {
        SetupApiLibrary.HDEVINFO deviceInfoHandle = SetupApiLibrary.SetupDiCreateDeviceInfoList(null, null);
        if (deviceInfoHandle != WinBase.INVALID_HANDLE_VALUE) {
            SetupApiLibrary.SP_DEVICE_INTERFACE_DATA deviceInterfaceData = new SetupApiLibrary.SP_DEVICE_INTERFACE_DATA();
            deviceInterfaceData.cbSize = deviceInterfaceData.size();
            if (SetupApiLibrary.SetupDiOpenDeviceInterface(deviceInfoHandle, name, 0, deviceInterfaceData)) {
                SetupApiLibrary.SP_DEVINFO_DATA deviceInfoData = new SetupApiLibrary.SP_DEVINFO_DATA();
                deviceInfoData.cbSize = deviceInfoData.size();
                if (SetupApiLibrary.SetupDiEnumDeviceInfo(deviceInfoHandle, 0, deviceInfoData)) {
                    char[] deviceIdChars = new char[255];
                    int[] deviceIdLen = new int[]{0};
                    if (SetupApiLibrary.SetupDiGetDeviceInstanceId(deviceInfoHandle, deviceInfoData, deviceIdChars, deviceIdChars.length, deviceIdLen)) {
                        String deviceId = new String(deviceIdChars, 0, deviceIdLen[0] - 1);
                        this.m_WindowsBackend.deviceRemoved(deviceId);
                    }
                }
                if (!SetupApiLibrary.SetupDiDeleteDeviceInterfaceData(deviceInfoHandle, deviceInterfaceData)) {
                    WindowsBackend.reportLastError();
                }
            }
        }
        if (!SetupApiLibrary.SetupDiDestroyDeviceInfoList(deviceInfoHandle)) {
            WindowsBackend.reportLastError();
        }
    }

    protected WinDef.LRESULT onDeviceChangeArrivalOrRemoveComplete(WinDef.LPARAM lParam, String action) {
        DBT.DEV_BROADCAST_HDR bhdr = new DBT.DEV_BROADCAST_HDR(lParam.longValue());
        switch (bhdr.dbch_devicetype) {
            case 5: {
                DBT.DEV_BROADCAST_DEVICEINTERFACE bdif = new DBT.DEV_BROADCAST_DEVICEINTERFACE(bhdr.getPointer());
                this.handleDeviceRemoval(bdif.getDbcc_name());
                break;
            }
            default: {
                return null;
            }
        }
        return new WinDef.LRESULT(1L);
    }

    protected WinDef.LRESULT onDeviceChangeRemoveComplete(WinDef.LPARAM lParam) {
        return this.onDeviceChangeArrivalOrRemoveComplete(lParam, "Remove Complete");
    }
}

