/*
 * Decompiled with CFR 0.152.
 */
package purejavahidapi.windows;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Cfgmgr32;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import purejavahidapi.HidDevice;
import purejavahidapi.HidDeviceInfo;
import purejavahidapi.shared.Backend;
import purejavahidapi.windows.DeviceRemovalHandler;
import purejavahidapi.windows.HidLibrary;
import purejavahidapi.windows.SetupApiLibrary;

public class WindowsBackend
extends Backend {
    @Override
    public void init() {
        new DeviceRemovalHandler(this);
    }

    @Override
    public void cleanup() {
    }

    public static void reportLastError() {
        int rc = Native.getLastError();
        if (rc != 0) {
            StackTraceElement ste = Thread.currentThread().getStackTrace()[2];
            String message = String.format("GetLastError() == %d at %s:%d\n", rc, ste.getFileName(), ste.getLineNumber());
            throw new RuntimeException(message);
        }
    }

    @Override
    public List<HidDeviceInfo> enumerateDevices() {
        try {
            LinkedList<HidDeviceInfo> list = new LinkedList<HidDeviceInfo>();
            SetupApiLibrary.GUID InterfaceClassGuid = new SetupApiLibrary.GUID(1293833650, 61807, 4559, 136, 203, 0, 17, 17, 0, 0, 48);
            SetupApiLibrary.SP_DEVINFO_DATA devinfo_data = new SetupApiLibrary.SP_DEVINFO_DATA();
            SetupApiLibrary.SP_DEVICE_INTERFACE_DATA device_interface_data = new SetupApiLibrary.SP_DEVICE_INTERFACE_DATA();
            SetupApiLibrary.SP_DEVICE_INTERFACE_DETAIL_DATA_A device_interface_detail_data = null;
            SetupApiLibrary.HDEVINFO device_info_set = null;
            devinfo_data.cbSize = devinfo_data.size();
            device_interface_data.cbSize = device_interface_data.size();
            device_info_set = SetupApiLibrary.SetupDiGetClassDevs(InterfaceClassGuid, null, null, 18);
            int deviceIndex = 0;
            while (true) {
                int[] required_size;
                WinNT.HANDLE devHandle = WinBase.INVALID_HANDLE_VALUE;
                if (!SetupApiLibrary.SetupDiEnumDeviceInterfaces(device_info_set, null, InterfaceClassGuid, deviceIndex, device_interface_data)) {
                    if (Kernel32.INSTANCE.GetLastError() == 259) break;
                    WindowsBackend.reportLastError();
                }
                if (!SetupApiLibrary.SetupDiGetDeviceInterfaceDetail(device_info_set, device_interface_data, null, 0, required_size = new int[]{0}, null) && Kernel32.INSTANCE.GetLastError() != 122) {
                    WindowsBackend.reportLastError();
                }
                int[] cbSize = new int[]{8, 6, 5};
                for (int i = 0; i < cbSize.length && !SetupApiLibrary.SetupDiGetDeviceInterfaceDetail(device_info_set, device_interface_data, device_interface_detail_data = new SetupApiLibrary.SP_DEVICE_INTERFACE_DETAIL_DATA_A(cbSize[i], required_size[0]), required_size[0], null, null); ++i) {
                    device_interface_detail_data = null;
                    if (Kernel32.INSTANCE.GetLastError() == 1784) continue;
                    WindowsBackend.reportLastError();
                }
                if (device_interface_detail_data != null) {
                    char[] driverNameChars = new char[256];
                    if (!SetupApiLibrary.SetupDiEnumDeviceInfo(device_info_set, deviceIndex, devinfo_data)) {
                        WindowsBackend.reportLastError();
                    } else if (!SetupApiLibrary.SetupDiGetDeviceRegistryProperty(device_info_set, devinfo_data, 7, null, driverNameChars, driverNameChars.length, null)) {
                        WindowsBackend.reportLastError();
                    } else {
                        int driverNameLen = 0;
                        while (driverNameChars[driverNameLen++] != '\u0000') {
                        }
                        String drivername = new String(driverNameChars, 0, driverNameLen - 1);
                        if ("HIDClass".equals(drivername)) {
                            if (!SetupApiLibrary.SetupDiGetDeviceRegistryProperty(device_info_set, devinfo_data, 9, null, driverNameChars, driverNameChars.length, null)) {
                                if (Kernel32.INSTANCE.GetLastError() != 13) {
                                    WindowsBackend.reportLastError();
                                }
                            } else {
                                String path;
                                char[] deviceIdChars = new char[256];
                                int[] deviceIdLen = new int[]{0};
                                if (!SetupApiLibrary.SetupDiGetDeviceInstanceId(device_info_set, devinfo_data, deviceIdChars, deviceIdChars.length, deviceIdLen)) {
                                    WindowsBackend.reportLastError();
                                }
                                String deviceId = new String(deviceIdChars);
                                int parent = devinfo_data.DevInst;
                                IntByReference rParent = new IntByReference();
                                while (Cfgmgr32.INSTANCE.CM_Get_Parent(rParent, parent, 0) == 0) {
                                    String parentId;
                                    int parentIdLen;
                                    Memory mIdChars;
                                    IntByReference iParentIdLen = new IntByReference(0);
                                    parent = rParent.getValue();
                                    if (Cfgmgr32.INSTANCE.CM_Get_Device_ID_Size(iParentIdLen, parent, 0) != 0) {
                                        WindowsBackend.reportLastError();
                                    }
                                    if (Cfgmgr32.INSTANCE.CM_Get_Device_ID(parent, (Pointer)(mIdChars = new Memory((long)((parentIdLen = iParentIdLen.getValue() + 1) * 2))), parentIdLen, 0) != 0) {
                                        WindowsBackend.reportLastError();
                                    }
                                    if (!(parentId = mIdChars.getString(0L)).startsWith("USB\\")) continue;
                                    deviceId = parentId;
                                    break;
                                }
                                if ((devHandle = WindowsBackend.openDeviceHandle(path = new String(device_interface_detail_data.DevicePath), true)) == WinBase.INVALID_HANDLE_VALUE) break;
                                HidLibrary.HIDD_ATTRIBUTES attrib = new HidLibrary.HIDD_ATTRIBUTES();
                                attrib.Size = new NativeLong((long)attrib.size());
                                HidLibrary.HidD_GetAttributes(devHandle, attrib);
                                list.add(new purejavahidapi.windows.HidDeviceInfo(path, deviceId, devHandle, attrib));
                                Kernel32.INSTANCE.CloseHandle(devHandle);
                            }
                        }
                    }
                }
                ++deviceIndex;
            }
            SetupApiLibrary.SetupDiDestroyDeviceInfoList(device_info_set);
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public HidDevice openDevice(HidDeviceInfo deviceInfo) throws IOException {
        return new purejavahidapi.windows.HidDevice(deviceInfo, this);
    }

    static WinNT.HANDLE openDeviceHandle(String path, boolean enumerate) {
        int desired_access = enumerate ? 0 : -1073741824;
        int share_mode = 3;
        WinNT.HANDLE handle = Kernel32.INSTANCE.CreateFile(path, desired_access, share_mode, null, 3, 0x40000000, null);
        return handle;
    }

    static interface EnumerateCallback {
    }
}

