/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.darcula;

import com.bulenkov.iconloader.util.ColorUtil;
import com.bulenkov.iconloader.util.GraphicsConfig;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;

public class DarculaTableHeaderUI
extends BasicTableHeaderUI {
    public static ComponentUI createUI(JComponent c) {
        return new DarculaTableHeaderUI();
    }

    @Override
    public void paint(Graphics g2, JComponent c) {
        Graphics2D g = (Graphics2D)g2;
        GraphicsConfig config = new GraphicsConfig(g);
        Color bg = c.getBackground();
        g.setPaint(bg);
        int h = c.getHeight();
        int w = c.getWidth();
        g.fillRect(0, 0, w, h);
        g.setPaint(ColorUtil.shift(bg, 0.75));
        g.drawLine(0, h - 1, w, h - 1);
        g.drawLine(w - 1, 0, w - 1, h - 1);
        Enumeration<TableColumn> columns = ((JTableHeader)c).getColumnModel().getColumns();
        Color lineColor = ColorUtil.shift(bg, 0.7);
        int offset = 0;
        while (columns.hasMoreElements()) {
            TableColumn column = columns.nextElement();
            if (!columns.hasMoreElements() || column.getWidth() <= 0) continue;
            g.setColor(lineColor);
            g.drawLine((offset += column.getWidth()) - 1, 1, offset - 1, h - 3);
        }
        config.restore();
        super.paint(g, c);
    }
}

