/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.darcula.ui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTabbedPaneUI;

public class DarculaTabbedPaneUI
extends BasicTabbedPaneUI {
    public static ComponentUI createUI(JComponent c) {
        return new DarculaTabbedPaneUI();
    }

    @Override
    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        g.setColor(this.lightHighlight);
        switch (tabPlacement) {
            case 2: 
            case 4: {
                super.paintTabBorder(g, tabPlacement, tabIndex, x, y, w, h, isSelected);
                break;
            }
            case 3: {
                if (tabIndex == 0) {
                    g.drawLine(x, y, x, y + h - 1);
                }
                g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
                g.drawLine(x + w - 1, y + h - 1, x + w - 1, y);
                break;
            }
            default: {
                if (tabIndex == 0) {
                    g.drawLine(x, y, x, y + h - 1);
                }
                g.drawLine(x, y, x + w - 1, y);
                g.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
            }
        }
    }

    @Override
    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        Color selectedColor = UIManager.getColor("TabbedPane.selected");
        g.setColor(!isSelected || selectedColor == null ? this.tabPane.getBackgroundAt(tabIndex) : selectedColor);
        switch (tabPlacement) {
            case 2: 
            case 4: {
                super.paintTabBackground(g, tabPlacement, tabIndex, x, y, w, h, isSelected);
                break;
            }
            case 3: {
                g.fillRect(x, y, w - 1, h - 1);
                break;
            }
            default: {
                g.fillRect(x, y + 1, w - 1, h - 1);
            }
        }
    }

    @Override
    protected void paintContentBorderTopEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        g.setColor(this.lightHighlight);
        if (tabPlacement != 1 || selectedIndex < 0 || selRect.y + selRect.height + 1 < y || selRect.x < x || selRect.x > x + w) {
            g.drawLine(x, y, x + w - 2, y);
        } else {
            g.drawLine(x, y, selRect.x - 1, y);
            if (selRect.x + selRect.width < x + w - 1) {
                g.drawLine(selRect.x + selRect.width - 1, y, x + w - 1, y);
            } else {
                g.setColor(this.shadow);
                g.drawLine(x + w - 2, y, x + w - 2, y);
            }
        }
    }

    @Override
    protected void paintContentBorderBottomEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        g.setColor(this.lightHighlight);
        if (tabPlacement != 3 || selectedIndex < 0 || selRect.y - 1 > h || selRect.x < x || selRect.x > x + w) {
            g.drawLine(x + 1, y + h - 1, x + w - 2, y + h - 1);
        } else {
            g.drawLine(x, y + h - 1, selRect.x - 1, y + h - 1);
            if (selRect.x + selRect.width < x + w - 1) {
                g.drawLine(selRect.x + selRect.width - 1, y + h - 1, x + w - 1, y + h - 1);
            }
        }
    }

    @Override
    protected Insets getContentBorderInsets(int tabPlacement) {
        Insets insets = this.contentBorderInsets;
        if (tabPlacement == 3) {
            insets = new Insets(insets.bottom, insets.left, insets.top, insets.right);
        }
        return insets;
    }
}

