/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.darcula.util;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;

public class ImageUtil {
    public static BufferedImage getBlankImage(int w, int h) {
        return new BufferedImage(w, h, 2);
    }

    public static Icon getCloseIcon(int size) {
        BufferedImage image = ImageUtil.getBlankImage(size, size);
        Graphics2D graphics = image.createGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        int start = size / 4;
        int end = size - start;
        BasicStroke stroke = new BasicStroke(2.0f, 1, 1);
        graphics.setStroke(stroke);
        Color color = UIManager.getColor("text");
        graphics.setColor(color);
        graphics.drawLine(start, start, end, end);
        graphics.drawLine(start, end, end, start);
        graphics.dispose();
        return new ImageIcon(image);
    }

    public static Icon getMaximizeIcon(int size) {
        BufferedImage image = ImageUtil.getBlankImage(size, size);
        Graphics2D graphics = image.createGraphics();
        int start = size / 4 - 1;
        int end = size - start;
        graphics.setColor(UIManager.getColor("text"));
        graphics.fillRect(start, start, end - start, 2);
        graphics.fillRect(start, start, 1, end - start);
        graphics.fillRect(end - 1, start, 1, end - start);
        graphics.fillRect(start, end - 1, end - start, 1);
        graphics.dispose();
        return new ImageIcon(image);
    }

    public static Icon getMinimizeIcon(int size) {
        BufferedImage image = ImageUtil.getBlankImage(size, size);
        Graphics2D graphics = image.createGraphics();
        int start = size / 4 - 2;
        int end = 3 * size / 4;
        size = end - start - 3;
        Color color = UIManager.getColor("text");
        graphics.setColor(color);
        graphics.fillRect(start + 2, end - 1, size, 3);
        graphics.dispose();
        return new ImageIcon(image);
    }

    public static Icon getRestoreIcon(int size) {
        BufferedImage image = ImageUtil.getBlankImage(size, size);
        Graphics2D graphics = image.createGraphics();
        int start = size / 4 - 1;
        int end = size - start;
        int smallSquareSize = end - start - 3;
        graphics.setColor(UIManager.getColor("text"));
        int mainStartY = end - smallSquareSize;
        graphics.fillRect(start, mainStartY, smallSquareSize, 2);
        graphics.fillRect(start, mainStartY, 1, smallSquareSize);
        graphics.fillRect(start + smallSquareSize - 1, mainStartY, 1, smallSquareSize);
        graphics.fillRect(start, mainStartY + smallSquareSize - 1, smallSquareSize, 1);
        int secondaryStartX = start + 3;
        int secondaryStartY = mainStartY - 3;
        graphics.fillRect(secondaryStartX, secondaryStartY, smallSquareSize, 2);
        graphics.fillRect(secondaryStartX + smallSquareSize - 1, secondaryStartY, 1, smallSquareSize);
        graphics.fillRect(start + smallSquareSize + 1, secondaryStartY + smallSquareSize - 1, 2, 1);
        graphics.dispose();
        return new ImageIcon(image);
    }

    public static BufferedImage getScaledIconImage(List<Image> imageList, int width, int height) {
        if (width == 0 || height == 0) {
            return null;
        }
        Image bestImage = null;
        int bestWidth = 0;
        int bestHeight = 0;
        double bestSimilarity = 3.0;
        for (Image im : imageList) {
            double scaleMeasure;
            int adjh;
            int adjw;
            int ih;
            int iw;
            if (im == null) continue;
            try {
                iw = im.getWidth(null);
                ih = im.getHeight(null);
            }
            catch (Exception e) {
                continue;
            }
            if (iw <= 0 || ih <= 0) continue;
            double scaleFactor = Math.min((double)width / (double)iw, (double)height / (double)ih);
            if (scaleFactor >= 2.0) {
                scaleFactor = Math.floor(scaleFactor);
                adjw = iw * (int)scaleFactor;
                adjh = ih * (int)scaleFactor;
                scaleMeasure = 1.0 - 0.5 / scaleFactor;
            } else if (scaleFactor >= 1.0) {
                scaleFactor = 1.0;
                adjw = iw;
                adjh = ih;
                scaleMeasure = 0.0;
            } else if (scaleFactor >= 0.75) {
                scaleFactor = 0.75;
                adjw = iw * 3 / 4;
                adjh = ih * 3 / 4;
                scaleMeasure = 0.3;
            } else if (scaleFactor >= 0.6666) {
                scaleFactor = 0.6666;
                adjw = iw * 2 / 3;
                adjh = ih * 2 / 3;
                scaleMeasure = 0.33;
            } else {
                double scaleDivider = Math.ceil(1.0 / scaleFactor);
                scaleFactor = 1.0 / scaleDivider;
                adjw = (int)Math.round((double)iw / scaleDivider);
                adjh = (int)Math.round((double)ih / scaleDivider);
                scaleMeasure = 1.0 - 1.0 / scaleDivider;
            }
            double similarity = ((double)width - (double)adjw) / (double)width + ((double)height - (double)adjh) / (double)height + scaleMeasure;
            if (similarity < bestSimilarity) {
                bestSimilarity = similarity;
                bestImage = im;
                bestWidth = adjw;
                bestHeight = adjh;
            }
            if (similarity != 0.0) continue;
            break;
        }
        if (bestImage == null) {
            return null;
        }
        BufferedImage bimage = ImageUtil.getBlankImage(width, height);
        Graphics2D g = bimage.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        int x = (width - bestWidth) / 2;
        int y = (height - bestHeight) / 2;
        g.drawImage(bestImage, x, y, bestWidth, bestHeight, null);
        g.dispose();
        return bimage;
    }
}

