/*
 * Decompiled with CFR 0.152.
 */
package io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;

public class ByteReader
extends InputStream {
    private boolean le = ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN);
    private InputStream stream;
    private int pos = 0;

    public ByteReader(InputStream in) {
        this.stream = in;
    }

    public int getPosition() {
        return this.pos;
    }

    public ByteReader changeEndiannes() {
        this.le = !this.le;
        return this;
    }

    public ByteReader setLittleEndian() {
        this.le = true;
        return this;
    }

    public ByteReader setBigEndian() {
        this.le = false;
        return this;
    }

    public boolean seek(int n) throws IOException {
        if (n <= 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            this.read();
        }
        return true;
    }

    public boolean seekTo(int newPos) throws IOException {
        return this.seek(newPos - this.pos);
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
        super.close();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int result = this.stream.read(b, off, len);
        this.pos += result;
        return result;
    }

    @Override
    public int read() throws IOException {
        ++this.pos;
        return this.stream.read();
    }

    public long read2bytes() throws IOException {
        long b0 = this.read();
        long b1 = this.read();
        if (this.le) {
            return b0 | b1 << 8;
        }
        return b1 | b0 << 8;
    }

    public long read3bytes() throws IOException {
        long b0 = this.read();
        long b1 = this.read();
        long b2 = this.read();
        if (this.le) {
            return b0 | b1 << 8 | b2 << 16;
        }
        return b2 | b1 << 8 | b0 << 16;
    }

    public long read4bytes() throws IOException {
        long b0 = this.read();
        long b1 = this.read();
        long b2 = this.read();
        long b3 = this.read();
        if (this.le) {
            return b0 | b1 << 8 | b2 << 16 | b3 << 24;
        }
        return b3 | b2 << 8 | b1 << 16 | b0 << 24;
    }

    public long read5bytes() throws IOException {
        long b0 = this.read();
        long b1 = this.read();
        long b2 = this.read();
        long b3 = this.read();
        long b4 = this.read();
        if (this.le) {
            return b0 | b1 << 8 | b2 << 16 | b3 << 24 | b4 << 32;
        }
        return b4 | b3 << 8 | b2 << 16 | b1 << 24 | b0 << 32;
    }

    public long read6bytes() throws IOException {
        long b0 = this.read();
        long b1 = this.read();
        long b2 = this.read();
        long b3 = this.read();
        long b4 = this.read();
        long b5 = this.read();
        if (this.le) {
            return b0 | b1 << 8 | b2 << 16 | b3 << 24 | b4 << 32 | b5 << 40;
        }
        return b5 | b4 << 8 | b3 << 16 | b2 << 24 | b1 << 32 | b0 << 40;
    }

    public long read7bytes() throws IOException {
        long b0 = this.read();
        long b1 = this.read();
        long b2 = this.read();
        long b3 = this.read();
        long b4 = this.read();
        long b5 = this.read();
        long b6 = this.read();
        if (this.le) {
            return b0 | b1 << 8 | b2 << 16 | b3 << 24 | b4 << 32 | b5 << 40 | b6 << 48;
        }
        return b6 | b5 << 8 | b4 << 16 | b3 << 24 | b2 << 32 | b1 << 40 | b0 << 48;
    }

    public long read8bytes() throws IOException {
        long b0 = this.read();
        long b1 = this.read();
        long b2 = this.read();
        long b3 = this.read();
        long b4 = this.read();
        long b5 = this.read();
        long b6 = this.read();
        long b7 = this.read();
        if (this.le) {
            return b0 | b1 << 8 | b2 << 16 | b3 << 24 | b4 << 32 | b5 << 40 | b6 << 48 | b7 << 56;
        }
        return b7 | b6 << 8 | b5 << 16 | b4 << 24 | b3 << 32 | b2 << 40 | b1 << 48 | b0 << 56;
    }

    public String readString(int sz) throws IOException {
        int b;
        int i;
        if (sz == 0) {
            return null;
        }
        byte[] buf = new byte[sz];
        for (i = 0; i < sz && (b = this.read()) != 0; ++i) {
            buf[i] = (byte)b;
        }
        if (i == 0) {
            return null;
        }
        return new String(buf, 0, i);
    }

    public String readUnicodeStringNullTerm(int sz) throws IOException {
        char c;
        int i;
        if (sz == 0) {
            return null;
        }
        char[] buf = new char[sz];
        for (i = 0; i < sz && (c = (char)this.read2bytes()) != '\u0000'; ++i) {
            buf[i] = c;
        }
        if (i == 0) {
            return null;
        }
        return new String(buf, 0, i);
    }

    public String readUnicodeStringSizePadded() throws IOException {
        int c = (int)this.read2bytes();
        char[] buf = new char[c];
        for (int i = 0; i < c; ++i) {
            buf[i] = (char)this.read2bytes();
        }
        return new String(buf);
    }
}

