/*
 * Decompiled with CFR 0.152.
 */
package io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;

public class ByteWriter
extends OutputStream {
    private boolean le = ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN);
    private OutputStream stream;
    private int pos = 0;

    public ByteWriter(OutputStream out) {
        this.stream = out;
    }

    public int getPosition() {
        return this.pos;
    }

    public ByteWriter changeEndiannes() {
        this.le = !this.le;
        return this;
    }

    public ByteWriter setLittleEndian() {
        this.le = true;
        return this;
    }

    public ByteWriter setBigEndian() {
        this.le = false;
        return this;
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
        super.close();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.pos += len;
        this.stream.write(b, off, len);
    }

    @Override
    public void write(int b) throws IOException {
        ++this.pos;
        this.stream.write(b);
    }

    public void write(long b) throws IOException {
        this.write((int)b);
    }

    public void write2bytes(long n) throws IOException {
        long b0 = n & 0xFFL;
        long b1 = (n & 0xFF00L) >> 8;
        if (this.le) {
            this.write(b0);
            this.write(b1);
        } else {
            this.write(b1);
            this.write(b0);
        }
    }

    public void write3bytes(long n) throws IOException {
        long b0 = n & 0xFFL;
        long b1 = (n & 0xFF00L) >> 8;
        long b2 = (n & 0xFF0000L) >> 16;
        if (this.le) {
            this.write(b0);
            this.write(b1);
            this.write(b2);
        } else {
            this.write(b2);
            this.write(b1);
            this.write(b0);
        }
    }

    public void write4bytes(long n) throws IOException {
        long b0 = n & 0xFFL;
        long b1 = (n & 0xFF00L) >> 8;
        long b2 = (n & 0xFF0000L) >> 16;
        long b3 = (n & 0xFFFFFFFFFF000000L) >>> 24;
        if (this.le) {
            this.write(b0);
            this.write(b1);
            this.write(b2);
            this.write(b3);
        } else {
            this.write(b3);
            this.write(b2);
            this.write(b1);
            this.write(b0);
        }
    }

    public void write5bytes(long n) throws IOException {
        long b0 = n & 0xFFL;
        long b1 = (n & 0xFF00L) >> 8;
        long b2 = (n & 0xFF0000L) >> 16;
        long b3 = (n & 0xFFFFFFFFFF000000L) >>> 24;
        long b4 = (n & 0xFF00000000L) >> 32;
        if (this.le) {
            this.write(b0);
            this.write(b1);
            this.write(b2);
            this.write(b3);
            this.write(b4);
        } else {
            this.write(b4);
            this.write(b3);
            this.write(b2);
            this.write(b1);
            this.write(b0);
        }
    }

    public void write6bytes(long n) throws IOException {
        long b0 = n & 0xFFL;
        long b1 = (n & 0xFF00L) >> 8;
        long b2 = (n & 0xFF0000L) >> 16;
        long b3 = (n & 0xFFFFFFFFFF000000L) >>> 24;
        long b4 = (n & 0xFF00000000L) >> 32;
        long b5 = (n & 0xFF0000000000L) >> 40;
        if (this.le) {
            this.write(b0);
            this.write(b1);
            this.write(b2);
            this.write(b3);
            this.write(b4);
            this.write(b5);
        } else {
            this.write(b5);
            this.write(b4);
            this.write(b3);
            this.write(b2);
            this.write(b1);
            this.write(b0);
        }
    }

    public void write7bytes(long n) throws IOException {
        long b0 = n & 0xFFL;
        long b1 = (n & 0xFF00L) >> 8;
        long b2 = (n & 0xFF0000L) >> 16;
        long b3 = (n & 0xFFFFFFFFFF000000L) >>> 24;
        long b4 = (n & 0xFF00000000L) >> 32;
        long b5 = (n & 0xFF0000000000L) >> 40;
        long b6 = (n & 0xFF000000000000L) >> 48;
        if (this.le) {
            this.write(b0);
            this.write(b1);
            this.write(b2);
            this.write(b3);
            this.write(b4);
            this.write(b5);
            this.write(b6);
        } else {
            this.write(b6);
            this.write(b5);
            this.write(b4);
            this.write(b3);
            this.write(b2);
            this.write(b1);
            this.write(b0);
        }
    }

    public void write8bytes(long n) throws IOException {
        long b0 = n & 0xFFL;
        long b1 = (n & 0xFF00L) >> 8;
        long b2 = (n & 0xFF0000L) >> 16;
        long b3 = (n & 0xFFFFFFFFFF000000L) >>> 24;
        long b4 = (n & 0xFF00000000L) >> 32;
        long b5 = (n & 0xFF0000000000L) >> 40;
        long b6 = (n & 0xFF000000000000L) >> 48;
        long b7 = (n & 0xFF00000000000000L) >>> 56;
        if (this.le) {
            this.write(b0);
            this.write(b1);
            this.write(b2);
            this.write(b3);
            this.write(b4);
            this.write(b5);
            this.write(b6);
            this.write(b7);
        } else {
            this.write(b7);
            this.write(b6);
            this.write(b5);
            this.write(b4);
            this.write(b3);
            this.write(b2);
            this.write(b1);
            this.write(b0);
        }
    }

    public void writeString(String s) throws IOException {
        this.write(s.getBytes());
        this.write(0);
    }

    public void writeUnicodeStringNullTerm(String s) throws IOException {
        for (int i = 0; i < s.length(); ++i) {
            this.write2bytes(s.charAt(i));
        }
        this.write2bytes(0L);
    }

    public void writeUnicodeStringSizePadded(String s) throws IOException {
        this.write2bytes(s.length());
        for (int i = 0; i < s.length(); ++i) {
            this.write2bytes(s.charAt(i));
        }
    }
}

