/*
 * Decompiled with CFR 0.152.
 */
package mslinks;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.regex.Pattern;
import mslinks.LinkInfo;
import mslinks.LinkTargetIDList;
import mslinks.ShellLink;
import mslinks.ShellLinkException;
import mslinks.data.GUID;
import mslinks.data.ItemID;
import mslinks.data.ItemIDDrive;
import mslinks.data.ItemIDFS;
import mslinks.data.ItemIDRoot;
import mslinks.data.Registry;

public class ShellLinkHelper {
    protected ShellLink link;
    private static Map<String, String> env = System.getenv();

    public ShellLinkHelper(ShellLink l) {
        this.link = l;
    }

    public ShellLink getLink() {
        return this.link;
    }

    public ShellLinkHelper setNetworkTarget(String path) throws ShellLinkException {
        return this.setNetworkTarget(path, Options.None);
    }

    public ShellLinkHelper setNetworkTarget(String path, Options options) throws ShellLinkException {
        if (!((String)path).startsWith("\\")) {
            path = "\\" + (String)path;
        }
        if (!((String)path).startsWith("\\\\")) {
            path = "\\" + (String)path;
        }
        int p1 = ((String)path).indexOf(92, 2);
        int p2 = ((String)path).indexOf(92, p1 + 1);
        if (p1 != -1) {
            boolean forceDirectory;
            LinkInfo info;
            LinkInfo linkInfo = info = this.link.getHeader().getLinkFlags().hasLinkInfo() ? this.link.getLinkInfo() : this.link.createLinkInfo();
            if (p2 != -1) {
                info.createCommonNetworkRelativeLink().setNetName(((String)path).substring(0, p2));
                info.setCommonPathSuffix(((String)path).substring(p2 + 1));
            } else {
                info.createCommonNetworkRelativeLink().setNetName((String)path);
                info.setCommonPathSuffix("");
            }
            this.link.getHeader().getFileAttributesFlags().setDirecory();
            boolean forceFile = options == Options.ForceTypeFile;
            boolean bl = forceDirectory = options == Options.ForceTypeDirectory;
            if (forceFile || !forceDirectory && Files.isRegularFile(Paths.get((String)path, new String[0]), new LinkOption[0])) {
                this.link.getHeader().getFileAttributesFlags().clearDirecory();
            }
        } else {
            this.link.getHeader().getFileAttributesFlags().clearDirecory();
        }
        this.link.getHeader().getLinkFlags().setHasExpString();
        this.link.getEnvironmentVariable().setVariable((String)path);
        return this;
    }

    public ShellLinkHelper setLocalTarget(String drive, String absolutePath) throws ShellLinkException {
        return this.setLocalTarget(drive, absolutePath, Options.None);
    }

    public ShellLinkHelper setLocalTarget(String drive, String absolutePath, Options options) throws ShellLinkException {
        boolean forceDirectory;
        String[] path;
        this.link.getHeader().getLinkFlags().setHasLinkTargetIDList();
        LinkTargetIDList idList = this.link.createTargetIdList();
        idList.add(new ItemIDRoot().setClsid(Registry.CLSID_COMPUTER));
        ItemIDDrive driveItem = new ItemIDDrive(15).setName(drive);
        idList.add(driveItem);
        absolutePath = absolutePath.replaceAll("^(\\\\|\\/)", "");
        String absoluteTargetPath = driveItem.getName() + absolutePath;
        for (String i : path = absolutePath.split("\\\\|\\/")) {
            idList.add(new ItemIDFS(1).setName(i));
        }
        LinkInfo info = this.link.getHeader().getLinkFlags().hasLinkInfo() ? this.link.getLinkInfo() : this.link.createLinkInfo();
        info.createVolumeID().setDriveType(3);
        info.setLocalBasePath(absoluteTargetPath);
        this.link.getHeader().getFileAttributesFlags().setDirecory();
        boolean forceFile = options == Options.ForceTypeFile;
        boolean bl = forceDirectory = options == Options.ForceTypeDirectory;
        if (forceFile || !forceDirectory && Files.isRegularFile(Paths.get(absoluteTargetPath, new String[0]), new LinkOption[0])) {
            this.link.getHeader().getFileAttributesFlags().clearDirecory();
            ((ItemID)idList.getLast()).setTypeFlags(2);
        }
        return this;
    }

    public ShellLinkHelper setSpecialFolderTarget(GUID root, String path, Options options) throws ShellLinkException {
        String[] pathSegments;
        if (options != Options.ForceTypeFile && options != Options.ForceTypeDirectory) {
            throw new ShellLinkException("The type of target is not specified. You have to specify whether it is a file or a directory.");
        }
        this.link.getHeader().getLinkFlags().setHasLinkTargetIDList();
        LinkTargetIDList idList = this.link.createTargetIdList();
        idList.add(new ItemIDRoot().setClsid(root));
        path = path.replaceAll("^(\\\\|\\/)", "");
        for (String i : pathSegments = path.split("\\\\|\\/")) {
            idList.add(new ItemIDFS(1).setName(i));
        }
        this.link.getHeader().getFileAttributesFlags().setDirecory();
        if (options == Options.ForceTypeFile) {
            this.link.getHeader().getFileAttributesFlags().clearDirecory();
            ((ItemID)idList.getLast()).setTypeFlags(2);
        }
        return this;
    }

    public ShellLinkHelper setDesktopRelativeTarget(String path, Options options) throws ShellLinkException {
        String[] pathSegments;
        if (options != Options.ForceTypeFile && options != Options.ForceTypeDirectory) {
            throw new ShellLinkException("The type of target is not specified. You have to specify whether it is a file or a directory.");
        }
        this.link.getHeader().getLinkFlags().setHasLinkTargetIDList();
        LinkTargetIDList idList = this.link.createTargetIdList();
        path = path.replaceAll("^(\\\\|\\/)", "");
        for (String i : pathSegments = path.split("\\\\|\\/")) {
            idList.add(new ItemIDFS(1).setName(i));
        }
        this.link.getHeader().getFileAttributesFlags().setDirecory();
        if (options == Options.ForceTypeFile) {
            this.link.getHeader().getFileAttributesFlags().clearDirecory();
            ((ItemID)idList.getLast()).setTypeFlags(2);
        }
        return this;
    }

    public ShellLinkHelper saveTo(String path) throws IOException {
        Path savingPath = Paths.get(path, new String[0]).toAbsolutePath().normalize();
        if (Files.isDirectory(savingPath, new LinkOption[0])) {
            throw new IOException("can't save ShellLink to \"" + savingPath + "\" because there is a directory with this name");
        }
        this.link.setLinkFileSource(savingPath);
        Path savingDir = savingPath.getParent();
        try {
            Path target = Paths.get(this.link.resolveTarget(), new String[0]);
            if (!this.link.getHeader().getLinkFlags().hasRelativePath() && savingDir.getRoot().equals(target.getRoot())) {
                this.link.setRelativePath(savingDir.relativize(target).toString());
            }
            if (!this.link.getHeader().getLinkFlags().hasWorkingDir() && Files.isRegularFile(target, new LinkOption[0])) {
                this.link.setWorkingDir(target.getParent().toString());
            }
        }
        catch (InvalidPathException invalidPathException) {
            // empty catch block
        }
        Files.createDirectories(savingDir, new FileAttribute[0]);
        this.link.serialize(Files.newOutputStream(savingPath, new OpenOption[0]));
        return this;
    }

    public static ShellLinkHelper createLink(String target, String linkpath) throws IOException, ShellLinkException {
        target = ShellLinkHelper.resolveEnvVariables(target);
        ShellLinkHelper helper = new ShellLinkHelper(new ShellLink());
        if (target.startsWith("\\\\")) {
            helper.setNetworkTarget(target);
        } else {
            String[] parts = target.split(":");
            if (parts.length != 2) {
                throw new ShellLinkException("Wrong path '" + target + "'");
            }
            helper.setLocalTarget(parts[0], parts[1]);
        }
        helper.saveTo(linkpath);
        return helper;
    }

    public static String resolveEnvVariables(String path) {
        for (Map.Entry<String, String> i : env.entrySet()) {
            String p = Pattern.quote(i.getKey());
            String r = i.getValue().replace("\\", "\\\\");
            path = Pattern.compile("%" + p + "%", 2).matcher(path).replaceAll(r);
        }
        return path;
    }

    public static enum Options {
        None,
        ForceTypeDirectory,
        ForceTypeFile;

    }
}

