/*
 * Decompiled with CFR 0.152.
 */
package mslinks.data;

import io.ByteReader;
import io.ByteWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import mslinks.Serializable;
import mslinks.ShellLinkException;
import mslinks.data.ItemIDDrive;
import mslinks.data.ItemIDFS;
import mslinks.data.ItemIDRegFolder;
import mslinks.data.ItemIDRoot;
import mslinks.data.ItemIDUnknown;
import mslinks.data.Registry;

public class ItemID
implements Serializable {
    public static final int ID_TYPE_JUNCTION = 128;
    public static final int ID_TYPE_GROUPMASK = 112;
    public static final int ID_TYPE_INGROUPMASK = 15;
    public static final int GROUP_ROOT = 16;
    public static final int GROUP_COMPUTER = 32;
    public static final int GROUP_FS = 48;
    public static final int GROUP_NET = 64;
    public static final int GROUP_LOC = 80;
    public static final int GROUP_CONTROLPANEL = 112;
    public static final int TYPE_ROOT_REGITEM = 15;
    public static final int TYPE_DRIVE_RESERVED_1 = 1;
    public static final int TYPE_DRIVE_REMOVABLE = 2;
    public static final int TYPE_DRIVE_FIXED = 3;
    public static final int TYPE_DRIVE_REMOTE = 4;
    public static final int TYPE_DRIVE_CDROM = 5;
    public static final int TYPE_DRIVE_RAMDISK = 6;
    public static final int TYPE_DRIVE_RESERVED_7 = 7;
    public static final int TYPE_DRIVE_DRIVE525 = 8;
    public static final int TYPE_DRIVE_DRIVE35 = 9;
    public static final int TYPE_DRIVE_NETDRIVE = 10;
    public static final int TYPE_DRIVE_NETUNAVAIL = 11;
    public static final int TYPE_DRIVE_RESERVED_C = 12;
    public static final int TYPE_DRIVE_RESERVED_D = 13;
    public static final int TYPE_DRIVE_REGITEM = 14;
    public static final int TYPE_DRIVE_MISC = 15;
    public static final int TYPE_FS_DIRECTORY = 1;
    public static final int TYPE_FS_FILE = 2;
    public static final int TYPE_FS_UNICODE = 4;
    public static final int TYPE_FS_COMMON = 8;
    public static final int TYPE_NET_DOMAIN = 1;
    public static final int TYPE_NET_SERVER = 2;
    public static final int TYPE_NET_SHARE = 3;
    public static final int TYPE_NET_FILE = 4;
    public static final int TYPE_NET_GROUP = 5;
    public static final int TYPE_NET_NETWORK = 6;
    public static final int TYPE_NET_RESTOFNET = 7;
    public static final int TYPE_NET_SHAREADMIN = 8;
    public static final int TYPE_NET_DIRECTORY = 9;
    public static final int TYPE_NET_TREE = 10;
    public static final int TYPE_NET_NDSCONTAINER = 11;
    public static final int TYPE_NET_REGITEM = 13;
    public static final int TYPE_NET_REMOTEREGITEM = 14;
    public static final int TYPE_NET_PRINTER = 15;
    public static final int TYPE_CONTROL_REGITEM = 0;
    public static final int TYPE_CONTROL_REGITEM_EX = 1;
    protected int typeFlags;
    @Deprecated(since="1.0.9", forRemoval=true)
    public static final int TYPE_UNKNOWN = 0;
    @Deprecated(since="1.0.9", forRemoval=true)
    public static final int TYPE_FILE_OLD = 54;
    @Deprecated(since="1.0.9", forRemoval=true)
    public static final int TYPE_DIRECTORY_OLD = 53;
    @Deprecated(since="1.0.9", forRemoval=true)
    public static final int TYPE_FILE = 50;
    @Deprecated(since="1.0.9", forRemoval=true)
    public static final int TYPE_DIRECTORY = 49;
    @Deprecated(since="1.0.9", forRemoval=true)
    public static final int TYPE_DRIVE_OLD = 35;
    @Deprecated(since="1.0.9", forRemoval=true)
    public static final int TYPE_DRIVE = 47;
    @Deprecated(since="1.0.9", forRemoval=true)
    public static final int TYPE_CLSID = 31;
    @Deprecated(since="1.0.9", forRemoval=true)
    private ItemID internalItemId;

    public static ItemID createItem(int typeFlags) throws ShellLinkException {
        if ((typeFlags & 0x80) != 0) {
            throw new ShellLinkException("junctions are not supported");
        }
        int group = typeFlags & 0x70;
        int subGroup = typeFlags & 0xF;
        switch (group) {
            case 16: {
                return new ItemIDRoot(typeFlags);
            }
            case 32: {
                if (subGroup == 14) {
                    return new ItemIDRegFolder(typeFlags);
                }
                return new ItemIDDrive(typeFlags);
            }
            case 48: {
                return new ItemIDFS(typeFlags);
            }
        }
        return new ItemIDUnknown(typeFlags);
    }

    @Deprecated(since="1.0.9", forRemoval=true)
    public ItemID(int flags) {
        this.typeFlags = flags;
        if (this.getClass() == ItemID.class) {
            try {
                this.internalItemId = ItemID.createItem(flags);
            }
            catch (ShellLinkException e) {
                this.internalItemId = new ItemIDUnknown(flags);
            }
        }
    }

    public void load(ByteReader br, int maxSize) throws IOException, ShellLinkException {
    }

    @Override
    public void serialize(ByteWriter bw) throws IOException {
        if (this.internalItemId != null) {
            this.internalItemId.serialize(bw);
        } else {
            bw.write(this.typeFlags);
        }
    }

    public String toString() {
        return "";
    }

    public int getTypeFlags() {
        if (this.internalItemId != null) {
            return this.internalItemId.getTypeFlags();
        }
        return this.typeFlags;
    }

    public ItemID setTypeFlags(int flags) throws ShellLinkException {
        if ((flags & 0x70) != 0) {
            throw new ShellLinkException("ItemID group cannot be changed. Create a new instance of an appropriate type instead.");
        }
        if ((flags & 0x80) != 0) {
            throw new ShellLinkException("Junctions are not supported");
        }
        this.typeFlags = this.typeFlags & 0x70 | flags & 0xF;
        return this;
    }

    protected static boolean isLongFilename(String filename) {
        if (filename.charAt(0) == '.' || filename.charAt(filename.length() - 1) == '.') {
            return true;
        }
        if (!filename.matches("^\\p{ASCII}+$")) {
            return true;
        }
        int dotIdx = filename.lastIndexOf(46);
        String baseName = dotIdx == -1 ? filename : filename.substring(0, dotIdx);
        String ext = dotIdx == -1 ? "" : filename.substring(dotIdx + 1);
        String wrongSymbolsPattern = ".*[\\.\"\\/\\\\\\[\\]:;=, ]+.*";
        return baseName.length() > 8 || ext.length() > 3 || baseName.matches(wrongSymbolsPattern) || ext.matches(wrongSymbolsPattern);
    }

    protected static String generateShortName(String longname) {
        int dotIdx = (longname = longname.replaceAll("\\.$|^\\.", "")).lastIndexOf(46);
        String baseName = dotIdx == -1 ? longname : longname.substring(0, dotIdx);
        String ext = dotIdx == -1 ? "" : longname.substring(dotIdx + 1);
        ext = ext.replace(" ", "").replaceAll("[\\.\"\\/\\\\\\[\\]:;=,\\+]", "_");
        ext = ext.substring(0, Math.min(3, ext.length()));
        baseName = baseName.replace(" ", "").replaceAll("[\\.\"\\/\\\\\\[\\]:;=,\\+]", "_");
        baseName = baseName.substring(0, Math.min(6, baseName.length()));
        StringBuilder shortname = new StringBuilder(baseName + "~1" + (String)(ext.isEmpty() ? "" : "." + ext));
        CharsetEncoder asciiEncoder = StandardCharsets.US_ASCII.newEncoder();
        for (int i = 0; i < shortname.length(); ++i) {
            if (asciiEncoder.canEncode(shortname.charAt(i))) continue;
            shortname.setCharAt(i, '_');
        }
        return shortname.toString().toUpperCase();
    }

    @Deprecated(since="1.0.9", forRemoval=true)
    public ItemID() {
    }

    @Deprecated(since="1.0.9", forRemoval=true)
    public ItemID(byte[] d) throws IOException, ShellLinkException {
        ByteReader br = new ByteReader(new ByteArrayInputStream(d));
        int flags = br.read();
        this.internalItemId = ItemID.createItem(flags);
        this.internalItemId.load(br, d.length - 1);
    }

    @Deprecated(since="1.0.9", forRemoval=true)
    public ItemID(ByteReader br, int maxSize) throws IOException, ShellLinkException {
        int flags = br.read();
        this.internalItemId = ItemID.createItem(flags);
        this.internalItemId.load(br, maxSize - 1);
    }

    @Deprecated(since="1.0.9", forRemoval=true)
    public String getName() {
        if (this.internalItemId instanceof ItemIDDrive) {
            return ((ItemIDDrive)this.internalItemId).getName();
        }
        if (this.internalItemId instanceof ItemIDFS) {
            return ((ItemIDFS)this.internalItemId).getName();
        }
        return "";
    }

    @Deprecated(since="1.0.9", forRemoval=true)
    public ItemID setName(String s) throws ShellLinkException {
        if (this.internalItemId instanceof ItemIDDrive) {
            ((ItemIDDrive)this.internalItemId).setName(s);
        } else if (this.internalItemId instanceof ItemIDFS) {
            ((ItemIDFS)this.internalItemId).setName(s);
        }
        return this;
    }

    @Deprecated(since="1.0.9", forRemoval=true)
    public int getSize() {
        if (this.internalItemId instanceof ItemIDFS) {
            return ((ItemIDFS)this.internalItemId).getSize();
        }
        return 0;
    }

    @Deprecated(since="1.0.9", forRemoval=true)
    public ItemID setSize(int s) throws ShellLinkException {
        if (this.internalItemId instanceof ItemIDFS) {
            ((ItemIDFS)this.internalItemId).setSize(s);
            return this;
        }
        throw new ShellLinkException("only files has size");
    }

    @Deprecated(since="1.0.9", forRemoval=true)
    public int getType() {
        return this.getTypeFlags();
    }

    @Deprecated(since="1.0.9", forRemoval=true)
    public ItemID setType(int t) throws ShellLinkException {
        if (t == 31) {
            this.internalItemId = new ItemIDRoot().setClsid(Registry.CLSID_COMPUTER);
            return this;
        }
        if (t == 50 || t == 49 || t == 54 || t == 53) {
            if (this.internalItemId instanceof ItemIDFS) {
                ((ItemIDFS)this.internalItemId).setTypeFlags(t & 0xF);
            } else if (this.internalItemId instanceof ItemIDDrive) {
                ItemIDDrive driveId = (ItemIDDrive)this.internalItemId;
                this.internalItemId = new ItemIDFS(t).setName(driveId.getName());
            } else if (this.internalItemId == null) {
                this.internalItemId = new ItemIDFS(t);
            }
            return this;
        }
        if (t == 47 || t == 35) {
            if (this.internalItemId instanceof ItemIDDrive) {
                ((ItemIDDrive)this.internalItemId).setTypeFlags(t & 0xF);
            } else if (this.internalItemId instanceof ItemIDFS) {
                ItemIDFS fsId = (ItemIDFS)this.internalItemId;
                this.internalItemId = new ItemIDDrive(t).setName(fsId.getName());
            } else if (this.internalItemId == null) {
                this.internalItemId = new ItemIDDrive(t);
            }
            return this;
        }
        throw new ShellLinkException("wrong type");
    }
}

