/*
 * Decompiled with CFR 0.152.
 */
package mslinks.data;

import io.ByteReader;
import io.ByteWriter;
import java.io.IOException;
import java.util.regex.Pattern;
import mslinks.ShellLinkException;
import mslinks.UnsupportedItemIDException;
import mslinks.data.ItemID;

public class ItemIDDrive
extends ItemID {
    protected String name;

    public ItemIDDrive(int flags) throws UnsupportedItemIDException {
        super(flags | 0x20);
        int subType = this.typeFlags & 0xF;
        if (subType == 0) {
            throw new UnsupportedItemIDException(this.typeFlags);
        }
    }

    @Override
    public void load(ByteReader br, int maxSize) throws IOException, ShellLinkException {
        int startPos = br.getPosition();
        int endPos = startPos + maxSize;
        super.load(br, maxSize);
        this.setName(br.readString(4));
        br.seekTo(endPos);
    }

    @Override
    public void serialize(ByteWriter bw) throws IOException {
        super.serialize(bw);
        bw.writeString(this.name);
        bw.write8bytes(0L);
        bw.write8bytes(0L);
        bw.write(0);
        bw.write(0);
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ItemIDDrive setName(String s) throws ShellLinkException {
        if (s == null) {
            return this;
        }
        if (Pattern.matches("\\w:\\\\", s)) {
            this.name = s;
        } else if (Pattern.matches("\\w:", s)) {
            this.name = s + "\\";
        } else if (Pattern.matches("\\w", s)) {
            this.name = s + ":\\";
        } else {
            throw new ShellLinkException("wrong drive name: " + s);
        }
        return this;
    }
}

