/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.ssl;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.ssl.ASN1Structure;
import org.apache.commons.ssl.ASN1Util;
import org.apache.commons.ssl.Certificates;
import org.apache.commons.ssl.PEMItem;
import org.apache.commons.ssl.PEMUtil;
import org.apache.commons.ssl.PKCS8Key;
import org.apache.commons.ssl.ProbablyBadPasswordException;
import org.apache.commons.ssl.Util;
import org.apache.commons.ssl.X509CertificateChainBuilder;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.DERSequence;

public class KeyStoreBuilder {
    private static final String PKCS7_ENCRYPTED = "1.2.840.113549.1.7.6";
    private static final Log logger = LogFactory.getLog(KeyStoreBuilder.class);

    public static KeyStore build(byte[] jksOrCerts, char[] password) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, ProbablyBadPasswordException, UnrecoverableKeyException {
        return KeyStoreBuilder.build(jksOrCerts, null, password);
    }

    public static KeyStore build(byte[] jksOrCerts, byte[] privateKey, char[] password) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, ProbablyBadPasswordException, UnrecoverableKeyException {
        return KeyStoreBuilder.build(jksOrCerts, privateKey, password, null);
    }

    public static KeyStore build(byte[] jksOrCerts, byte[] privateKey, char[] jksPassword, char[] keyPassword) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, ProbablyBadPasswordException, UnrecoverableKeyException {
        boolean atLeastOneNotSet;
        if (keyPassword == null || keyPassword.length <= 0) {
            keyPassword = jksPassword;
        }
        BuildResult br1 = KeyStoreBuilder.parse(jksOrCerts, jksPassword, keyPassword);
        BuildResult br2 = null;
        KeyStore jks = null;
        if (br1.jks != null) {
            jks = br1.jks;
        } else if (privateKey != null && privateKey.length > 0) {
            br2 = KeyStoreBuilder.parse(privateKey, jksPassword, keyPassword);
            if (br2.jks != null) {
                jks = br2.jks;
            }
        }
        if (jks != null && (br1 = KeyStoreBuilder.validate(jks, keyPassword)) == null) {
            return jks;
        }
        List keys = br1.keys;
        List chains = br1.chains;
        boolean bl = atLeastOneNotSet = keys == null || chains == null || keys.isEmpty() || chains.isEmpty();
        if (atLeastOneNotSet && br2 != null) {
            if (br2.keys != null && !br2.keys.isEmpty()) {
                keys = br2.keys;
            }
            if (chains == null || chains.isEmpty()) {
                chains = br2.chains;
            }
        }
        boolean bl2 = atLeastOneNotSet = keys == null || chains == null || keys.isEmpty() || chains.isEmpty();
        if (atLeastOneNotSet) {
            String missing = "";
            if (keys == null) {
                missing = " [Private key missing (bad password?)]";
            }
            if (chains == null) {
                missing = missing + " [Certificate chain missing]";
            }
            throw new KeyStoreException("Can't build keystore:" + missing);
        }
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        ks.load(null, jksPassword);
        Iterator keysIt = keys.iterator();
        Iterator chainsIt = chains.iterator();
        int i = 1;
        while (keysIt.hasNext() && chainsIt.hasNext()) {
            Key key = (Key)keysIt.next();
            Certificate[] c = (Certificate[])chainsIt.next();
            X509Certificate theOne = KeyStoreBuilder.buildChain(key, c);
            String alias = "alias_" + i++;
            if (theOne != null) {
                c = Certificates.trimChain(c);
                alias = Certificates.getCN(theOne);
                alias = alias.replace(' ', '_');
            }
            ks.setKeyEntry(alias, key, keyPassword, c);
        }
        return ks;
    }

    public static X509Certificate buildChain(Key key, Certificate[] chain) throws CertificateException, KeyStoreException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException {
        X509Certificate theOne = null;
        if (key instanceof RSAPrivateCrtKey) {
            RSAPrivateCrtKey rsa = (RSAPrivateCrtKey)key;
            BigInteger publicExponent = rsa.getPublicExponent();
            BigInteger modulus = rsa.getModulus();
            for (int i = 0; i < chain.length; ++i) {
                X509Certificate c = (X509Certificate)chain[i];
                PublicKey pub = c.getPublicKey();
                if (!(pub instanceof RSAPublicKey)) continue;
                RSAPublicKey certKey = (RSAPublicKey)pub;
                BigInteger pe = certKey.getPublicExponent();
                BigInteger mod = certKey.getModulus();
                if (!publicExponent.equals(pe) || !modulus.equals(mod)) continue;
                theOne = c;
            }
            if (theOne == null) {
                throw new KeyStoreException("Can't build keystore: [No certificates belong to the private-key]");
            }
            X509Certificate[] newChain = X509CertificateChainBuilder.buildPath(theOne, chain);
            Arrays.fill(chain, null);
            System.arraycopy(newChain, 0, chain, 0, newChain.length);
        }
        return theOne;
    }

    public static BuildResult validate(KeyStore jks, char[] keyPass) throws CertificateException, KeyStoreException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, UnrecoverableKeyException {
        Enumeration<String> en = jks.aliases();
        boolean atLeastOneSuccess = false;
        boolean atLeastOneFailure = false;
        LinkedList<PrivateKey> keys = new LinkedList<PrivateKey>();
        LinkedList<Certificate[]> chains = new LinkedList<Certificate[]>();
        while (en.hasMoreElements()) {
            String alias = en.nextElement();
            if (!jks.isKeyEntry(alias)) continue;
            try {
                PrivateKey key = (PrivateKey)jks.getKey(alias, keyPass);
                atLeastOneSuccess = true;
                Certificate[] chain = jks.getCertificateChain(alias);
                if (chain == null) continue;
                Certificate[] c = Certificates.x509ifyChain(chain);
                X509Certificate theOne = KeyStoreBuilder.buildChain(key, c);
                if (theOne != null) {
                    c = (X509Certificate[])Certificates.trimChain(c);
                    jks.deleteEntry(alias);
                    jks.setKeyEntry(alias, key, keyPass, c);
                }
                keys.add(key);
                chains.add(c);
            }
            catch (GeneralSecurityException gse) {
                atLeastOneFailure = true;
            }
        }
        if (!atLeastOneSuccess) {
            throw new KeyStoreException("No private keys found in keystore!");
        }
        return atLeastOneFailure ? new BuildResult(keys, chains, null) : null;
    }

    public static BuildResult parse(byte[] stuff, char[] jksPass, char[] keyPass) throws IOException, CertificateException, KeyStoreException, ProbablyBadPasswordException {
        return KeyStoreBuilder.parse(stuff, jksPass, keyPass, false);
    }

    static BuildResult parse(byte[] stuff, char[] jksPass, char[] keyPass, boolean forTrustMaterial) throws IOException, CertificateException, KeyStoreException, ProbablyBadPasswordException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        PrivateKey key = null;
        X509Certificate[] chain = null;
        try {
            PKCS8Key pkcs8Key = new PKCS8Key(stuff, jksPass);
            key = pkcs8Key.getPrivateKey();
        }
        catch (ProbablyBadPasswordException pbpe) {
            throw pbpe;
        }
        catch (GeneralSecurityException pbpe) {
            // empty catch block
        }
        List pemItems = PEMUtil.decode(stuff);
        Iterator<Object> it = pemItems.iterator();
        LinkedList<X509Certificate> certificates = new LinkedList<X509Certificate>();
        while (it.hasNext()) {
            PEMItem item = (PEMItem)it.next();
            byte[] derBytes = item.getDerBytes();
            String type = item.pemType.trim().toUpperCase();
            if (type.startsWith("CERT") || type.startsWith("X509") || type.startsWith("PKCS7")) {
                ByteArrayInputStream in = new ByteArrayInputStream(derBytes);
                X509Certificate c = (X509Certificate)cf.generateCertificate(in);
                certificates.add(c);
            }
            chain = KeyStoreBuilder.toChain(certificates);
        }
        if (chain != null || key != null) {
            List<Object> chains = chain != null ? Collections.singletonList(chain) : null;
            List<PrivateKey> keys = key != null ? Collections.singletonList(key) : null;
            return new BuildResult(keys, chains, null);
        }
        boolean isProbablyPKCS12 = false;
        boolean isASN = false;
        ASN1Structure asn1 = null;
        try {
            asn1 = ASN1Util.analyze(stuff);
            isASN = true;
            isProbablyPKCS12 = asn1.oids.contains(PKCS7_ENCRYPTED);
            if (!isProbablyPKCS12 && asn1.bigPayload != null) {
                asn1 = ASN1Util.analyze(asn1.bigPayload);
                isProbablyPKCS12 = asn1.oids.contains(PKCS7_ENCRYPTED);
            }
        }
        catch (Exception in) {
            // empty catch block
        }
        ByteArrayInputStream stuffStream = new ByteArrayInputStream(stuff);
        BuildResult br = KeyStoreBuilder.tryJKS(KeyStore.getDefaultType(), stuffStream, jksPass, keyPass, forTrustMaterial);
        if (br == null && (br = KeyStoreBuilder.tryJKS("jks", stuffStream, jksPass, keyPass, forTrustMaterial)) == null && (br = KeyStoreBuilder.tryJKS("jceks", stuffStream, jksPass, keyPass, forTrustMaterial)) == null && (br = KeyStoreBuilder.tryJKS("BKS", stuffStream, jksPass, keyPass, forTrustMaterial)) == null) {
            br = KeyStoreBuilder.tryJKS("UBER", stuffStream, jksPass, keyPass, forTrustMaterial);
        }
        if (br != null) {
            return br;
        }
        if (isASN && isProbablyPKCS12) {
            br = KeyStoreBuilder.tryJKS("pkcs12", stuffStream, jksPass, null, forTrustMaterial);
        }
        if (br == null) {
            stuffStream.reset();
            try {
                certificates = new LinkedList();
                Collection<? extends Certificate> certs = cf.generateCertificates(stuffStream);
                for (X509Certificate x509Certificate : certs) {
                    certificates.add(x509Certificate);
                }
                chain = KeyStoreBuilder.toChain(certificates);
                if (chain != null && chain.length > 0) {
                    List<X509Certificate[]> list = Collections.singletonList(chain);
                    return new BuildResult(null, list, null);
                }
            }
            catch (CertificateException certs) {
                // empty catch block
            }
            stuffStream.reset();
            try {
                Certificate c = cf.generateCertificate(stuffStream);
                X509Certificate x509Certificate = (X509Certificate)c;
                chain = KeyStoreBuilder.toChain(Collections.singleton(x509Certificate));
                if (chain != null && chain.length > 0) {
                    List<X509Certificate[]> chains = Collections.singletonList(chain);
                    return new BuildResult(null, chains, null);
                }
            }
            catch (CertificateException certificateException) {
                // empty catch block
            }
        }
        if ((br = KeyStoreBuilder.tryJKS("pkcs12", stuffStream, jksPass, null, forTrustMaterial)) != null) {
            return br;
        }
        throw new KeyStoreException("failed to extract any certificates or private keys - maybe bad password?");
    }

    private static BuildResult tryJKS(String keystoreType, ByteArrayInputStream in, char[] jksPassword, char[] keyPassword, boolean forTrustMaterial) throws ProbablyBadPasswordException {
        in.reset();
        if (keyPassword == null || keyPassword.length <= 0) {
            keyPassword = jksPassword;
        }
        keystoreType = keystoreType.trim().toLowerCase();
        boolean isPKCS12 = "pkcs12".equalsIgnoreCase(keystoreType);
        try {
            Key key = null;
            Certificate[] chain = null;
            UnrecoverableKeyException uke = null;
            KeyStore jksKeyStore = KeyStore.getInstance(keystoreType);
            jksKeyStore.load(in, jksPassword);
            Enumeration<String> en = jksKeyStore.aliases();
            while (en.hasMoreElements()) {
                String alias = en.nextElement();
                if (jksKeyStore.isKeyEntry(alias)) {
                    try {
                        if (keyPassword != null) {
                            key = jksKeyStore.getKey(alias, keyPassword);
                        }
                        if (key instanceof PrivateKey) {
                            chain = jksKeyStore.getCertificateChain(alias);
                            break;
                        }
                    }
                    catch (UnrecoverableKeyException e) {
                        uke = e;
                    }
                    catch (GeneralSecurityException e) {
                        // empty catch block
                    }
                }
                if (!isPKCS12 || !en.hasMoreElements()) continue;
                logger.debug((Object)"what kind of weird pkcs12 file has more than one alias?");
            }
            if (key == null && uke != null && !forTrustMaterial) {
                throw new ProbablyBadPasswordException("Probably bad JKS-Key password: " + uke);
            }
            if (isPKCS12) {
                jksKeyStore = null;
                if (key == null) {
                    throw new GeneralSecurityException("No key found.");
                }
            }
            List<Object> keys = Collections.singletonList(key);
            List<Object> chains = Collections.singletonList(chain);
            return new BuildResult(keys, chains, jksKeyStore);
        }
        catch (ProbablyBadPasswordException pbpe) {
            throw pbpe;
        }
        catch (GeneralSecurityException gse) {
            return null;
        }
        catch (IOException ioe) {
            String msg = ioe.getMessage();
            String string = msg = msg != null ? msg.trim().toLowerCase() : "";
            if (isPKCS12) {
                int x = msg.indexOf("failed to decrypt");
                int y = msg.indexOf("verify mac");
                if ((x = Math.max(x, y)) >= 0) {
                    throw new ProbablyBadPasswordException("Probably bad PKCS12 password: " + ioe);
                }
            } else {
                int x = msg.indexOf("password");
                if (x >= 0) {
                    throw new ProbablyBadPasswordException("Probably bad JKS password: " + ioe);
                }
            }
            return null;
        }
    }

    private static X509Certificate[] toChain(Collection certs) {
        if (certs != null && !certs.isEmpty()) {
            X509Certificate[] x509Chain = new X509Certificate[certs.size()];
            certs.toArray(x509Chain);
            return x509Chain;
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.out.println("KeyStoreBuilder:  creates '[alias].jks' (Java Key Store)");
            System.out.println("    -topk8 mode:  creates '[alias].pem' (x509 chain + unencrypted pkcs8)");
            System.out.println("[alias] will be set to the first CN value of the X509 certificate.");
            System.out.println("-------------------------------------------------------------------");
            System.out.println("Usage1: [password] [file:pkcs12]");
            System.out.println("Usage2: [password] [file:private-key] [file:certificate-chain]");
            System.out.println("Usage3: -topk8 [password] [file:jks]");
            System.out.println("-------------------------------------------------------------------");
            System.out.println("[private-key] can be openssl format, or pkcs8.");
            System.out.println("[password] decrypts [private-key], and also encrypts outputted JKS file.");
            System.out.println("All files can be PEM or DER.");
            System.exit(1);
        }
        char[] password = args[0].toCharArray();
        boolean toPKCS8 = false;
        if ("-topk8".equalsIgnoreCase(args[0])) {
            toPKCS8 = true;
            password = args[1].toCharArray();
            args[1] = args[2];
            args[2] = null;
        }
        FileInputStream fin1 = new FileInputStream(args[1]);
        byte[] bytes1 = Util.streamToBytes(fin1);
        byte[] bytes2 = null;
        if (args.length > 2 && args[2] != null) {
            FileInputStream fin2 = new FileInputStream(args[2]);
            bytes2 = Util.streamToBytes(fin2);
        }
        KeyStore ks = KeyStoreBuilder.build(bytes1, bytes2, password);
        Enumeration<String> en = ks.aliases();
        String alias = "keystorebuilder";
        int biggestKey = 0;
        while (en.hasMoreElements()) {
            String s = en.nextElement();
            try {
                PrivateKey pk = (PrivateKey)ks.getKey(s, password);
                byte[] encoded = pk.getEncoded();
                int len = encoded != null ? encoded.length : 0;
                if (len < biggestKey) continue;
                biggestKey = len;
                alias = s;
            }
            catch (Exception pk) {}
        }
        String suffix = toPKCS8 ? ".pem" : ".jks";
        String fileName = alias;
        Certificate[] chain = ks.getCertificateChain(alias);
        if (chain != null && chain[0] != null) {
            String cn = Certificates.getCN((X509Certificate)chain[0]);
            String string = cn = cn != null ? cn.trim() : "";
            if (!"".equals(cn)) {
                fileName = cn;
            }
        }
        File f = new File(fileName + suffix);
        int count = 1;
        while (f.exists()) {
            f = new File(alias + "_" + count + suffix);
            ++count;
        }
        FileOutputStream fout = new FileOutputStream(f);
        if (toPKCS8) {
            LinkedList<PEMItem> pemItems = new LinkedList<PEMItem>();
            PrivateKey key = (PrivateKey)ks.getKey(alias, password);
            chain = ks.getCertificateChain(alias);
            byte[] pkcs8DerBytes = null;
            if (key instanceof RSAPrivateCrtKey) {
                RSAPrivateCrtKey rsa = (RSAPrivateCrtKey)key;
                ASN1EncodableVector vec = new ASN1EncodableVector();
                vec.add((ASN1Encodable)new ASN1Integer(BigInteger.ZERO));
                vec.add((ASN1Encodable)new ASN1Integer(rsa.getModulus()));
                vec.add((ASN1Encodable)new ASN1Integer(rsa.getPublicExponent()));
                vec.add((ASN1Encodable)new ASN1Integer(rsa.getPrivateExponent()));
                vec.add((ASN1Encodable)new ASN1Integer(rsa.getPrimeP()));
                vec.add((ASN1Encodable)new ASN1Integer(rsa.getPrimeQ()));
                vec.add((ASN1Encodable)new ASN1Integer(rsa.getPrimeExponentP()));
                vec.add((ASN1Encodable)new ASN1Integer(rsa.getPrimeExponentQ()));
                vec.add((ASN1Encodable)new ASN1Integer(rsa.getCrtCoefficient()));
                DERSequence seq = new DERSequence(vec);
                byte[] derBytes = PKCS8Key.encode((ASN1Encodable)seq);
                PKCS8Key pkcs8 = new PKCS8Key(derBytes, null);
                pkcs8DerBytes = pkcs8.getDecryptedBytes();
            } else if (key instanceof DSAPrivateKey) {
                DSAPrivateKey dsa = (DSAPrivateKey)key;
                DSAParams params = dsa.getParams();
                BigInteger g = params.getG();
                BigInteger p = params.getP();
                BigInteger q = params.getQ();
                BigInteger x = dsa.getX();
                BigInteger y = q.modPow(x, p);
                ASN1EncodableVector vec = new ASN1EncodableVector();
                vec.add((ASN1Encodable)new ASN1Integer(BigInteger.ZERO));
                vec.add((ASN1Encodable)new ASN1Integer(p));
                vec.add((ASN1Encodable)new ASN1Integer(q));
                vec.add((ASN1Encodable)new ASN1Integer(g));
                vec.add((ASN1Encodable)new ASN1Integer(y));
                vec.add((ASN1Encodable)new ASN1Integer(x));
                DERSequence seq = new DERSequence(vec);
                byte[] derBytes = PKCS8Key.encode((ASN1Encodable)seq);
                PKCS8Key pkcs8 = new PKCS8Key(derBytes, null);
                pkcs8DerBytes = pkcs8.getDecryptedBytes();
            }
            if (chain != null && chain.length > 0) {
                for (int i = 0; i < chain.length; ++i) {
                    X509Certificate x509 = (X509Certificate)chain[i];
                    byte[] derBytes = x509.getEncoded();
                    PEMItem item = new PEMItem(derBytes, "CERTIFICATE");
                    pemItems.add(item);
                }
            }
            if (pkcs8DerBytes != null) {
                PEMItem item = new PEMItem(pkcs8DerBytes, "PRIVATE KEY");
                pemItems.add(item);
            }
            byte[] pem = PEMUtil.encode(pemItems);
            fout.write(pem);
        } else {
            KeyStore jks = KeyStore.getInstance(KeyStore.getDefaultType());
            jks.load(null, password);
            jks.setKeyEntry(alias, ks.getKey(alias, password), password, ks.getCertificateChain(alias));
            jks.store(fout, password);
        }
        fout.flush();
        fout.close();
        System.out.println("Successfuly wrote: [" + f.getPath() + "]");
    }

    public static class BuildResult {
        protected final List keys;
        protected final List chains;
        protected final KeyStore jks;

        protected BuildResult(List keys, List chains, KeyStore jks) {
            this.keys = keys == null || keys.isEmpty() ? null : Collections.unmodifiableList(keys);
            this.jks = jks;
            LinkedList<X509Certificate[]> x509Chains = new LinkedList<X509Certificate[]>();
            if (chains != null) {
                for (Certificate[] chain : chains) {
                    if (chain == null || chain.length <= 0) continue;
                    int len = chain.length;
                    X509Certificate[] x509 = new X509Certificate[len];
                    for (int i = 0; i < x509.length; ++i) {
                        x509[i] = (X509Certificate)chain[i];
                    }
                    x509Chains.add(x509);
                }
            }
            this.chains = x509Chains == null || x509Chains.isEmpty() ? null : Collections.unmodifiableList(x509Chains);
        }
    }
}

